/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.impl.CommandResult;
import com.vaadin.signals.impl.MutableTreeRevision;
import com.vaadin.signals.impl.SignalTree;
import com.vaadin.signals.impl.StagedTransaction;
import com.vaadin.signals.impl.TreeRevision;
import com.vaadin.signals.operations.SignalOperation;
import com.vaadin.signals.operations.TransactionOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class Transaction {
    private static final Transaction ROOT = new ImmediateTransaction(){

        @Override
        public TreeRevision read(SignalTree tree) {
            return tree.submitted();
        }
    };
    private static final ThreadLocal<Transaction> currentTransaction = new ThreadLocal();

    public static Transaction getCurrent() {
        Transaction transaction = currentTransaction.get();
        if (transaction == null) {
            return ROOT;
        }
        return transaction;
    }

    public static boolean inTransaction() {
        return currentTransaction.get() != null;
    }

    public static <T> TransactionOperation<T> runInTransaction(Supplier<T> transactionTask) {
        return Transaction.runInTransaction(transactionTask, Type.STAGED);
    }

    public static <T> TransactionOperation<T> runInTransaction(Supplier<T> transactionTask, Type transactionType) {
        Transaction outer = Transaction.getCurrent();
        Transaction inner = transactionType.create(outer);
        currentTransaction.set(inner);
        try {
            T value = transactionTask.get();
            TransactionOperation<T> op = new TransactionOperation<T>(value);
            inner.commit(op.result()::complete);
            TransactionOperation<T> transactionOperation = op;
            return transactionOperation;
        }
        catch (RuntimeException e) {
            inner.rollback();
            throw e;
        }
        finally {
            if (outer == ROOT) {
                currentTransaction.remove();
            } else {
                currentTransaction.set(outer);
            }
        }
    }

    private static Supplier<Void> asSupplier(Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }

    public static TransactionOperation<Void> runInTransaction(Runnable transactionTask, Type transactionType) {
        return Transaction.runInTransaction(Transaction.asSupplier(transactionTask), transactionType);
    }

    public static TransactionOperation<Void> runInTransaction(Runnable transactionTask) {
        return Transaction.runInTransaction(Transaction.asSupplier(transactionTask));
    }

    public static <T> T runWithoutTransaction(Supplier<T> task) {
        Transaction previousTransaction = currentTransaction.get();
        try {
            currentTransaction.set(null);
            T t = task.get();
            return t;
        }
        finally {
            currentTransaction.set(previousTransaction);
        }
    }

    public static void runWithoutTransaction(Runnable task) {
        Transaction.runWithoutTransaction(Transaction.asSupplier(task));
    }

    protected abstract void include(SignalTree var1, SignalCommand var2, Consumer<CommandResult> var3, boolean var4);

    public void include(SignalTree tree, SignalCommand command, Consumer<CommandResult> resultHandler) {
        this.include(tree, command, resultHandler, true);
    }

    public abstract TreeRevision read(SignalTree var1);

    protected abstract void commit(Consumer<SignalOperation.ResultOrError<Void>> var1);

    protected abstract void rollback();

    public static enum Type {
        STAGED{

            @Override
            Transaction create(Transaction outer) {
                return new StagedTransaction(outer);
            }
        }
        ,
        WRITE_THROUGH{

            @Override
            Transaction create(Transaction outer) {
                return new RepeatableReadTransaction(outer);
            }
        };


        abstract Transaction create(Transaction var1) throws IllegalStateException;
    }

    private static class RepeatableReadTransaction
    extends ImmediateTransaction {
        private final Map<SignalTree, MutableTreeRevision> trees = new HashMap<SignalTree, MutableTreeRevision>();
        private final Transaction outer;

        public RepeatableReadTransaction(Transaction outer) {
            assert (outer != null);
            this.outer = outer;
        }

        private MutableTreeRevision getOrCreateReadRevision(SignalTree tree) {
            return this.trees.computeIfAbsent(tree, newTree -> new MutableTreeRevision(this.outer.read((SignalTree)newTree)));
        }

        @Override
        public void include(SignalTree tree, SignalCommand command, Consumer<CommandResult> resultHandler, boolean applyToTree) {
            this.getOrCreateReadRevision(tree).apply(command, null);
            super.include(tree, command, resultHandler, applyToTree);
            this.outer.include(tree, command, null, false);
        }

        @Override
        public TreeRevision read(SignalTree tree) {
            return this.getOrCreateReadRevision(tree);
        }
    }

    private static abstract class ImmediateTransaction
    extends Transaction {
        private ImmediateTransaction() {
        }

        @Override
        public void include(SignalTree tree, SignalCommand command, Consumer<CommandResult> resultHandler, boolean applyToTree) {
            if (applyToTree) {
                tree.commitSingleCommand(command, resultHandler);
            }
        }

        @Override
        protected void commit(Consumer<SignalOperation.ResultOrError<Void>> resultHandler) {
            resultHandler.accept(new SignalOperation.Result<Object>(null));
        }

        @Override
        protected void rollback() {
        }
    }
}

