/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.artur.open;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.vaadin.artur.open.LinuxProcFileReader;

public class OSUtils {
    public static long getTotalPhysicalMemory() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
            return (Long)attribute;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static Long getLongProperty(String name) {
        return OSUtils.getLongProperty(name, 10);
    }

    public static Long getLongProperty(String name, int radix) {
        String value = System.getProperty(name);
        try {
            return value == null ? null : Long.valueOf(OSUtils.longValueOf(value, radix));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static long longValueOf(String value, int radix) {
        if (radix == 16 && value.startsWith("0x")) {
            return Long.valueOf(value.substring(2), radix);
        }
        return Long.valueOf(value, radix);
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isLinux() {
        return OSUtils.getOsName().toLowerCase().startsWith("linux");
    }

    public static boolean isMac() {
        return OSUtils.getOsName().toLowerCase().startsWith("mac");
    }

    public static boolean isWindows() {
        return OSUtils.getOsName().toLowerCase().startsWith("windows");
    }

    public static boolean isWsl() {
        LinuxProcFileReader lpfr = new LinuxProcFileReader();
        return lpfr.isWsl();
    }
}

