/**
 * Copyright (C) 2020 Vaadin Ltd
 *
 * This program is available under Commercial Vaadin Developer License
 * 4.0 (CVDLv4).
 *
 *
 * For the full License, see <https://vaadin.com/license/cvdl-4.0>.
 */
package com.vaadin.mpr.client;

import java.util.HashMap;

import com.vaadin.mpr.MprUIContent;
import com.vaadin.mpr.core.client.AbstractMprUIContentConnector;
import com.vaadin.mpr.core.client.ComponentSettings;
import com.vaadin.shared.Connector;
import com.vaadin.shared.ui.Connect;

@Connect(MprUIContent.class)
public class MprUIContentConnector extends AbstractMprUIContentConnector {

    @Override
    public MprUIContentState getState() {
        return (MprUIContentState) super.getState();
    }

    @Override
    protected HashMap<Connector, ComponentSettings> getComponentSettings() {
        return getState().componentSettings;
    }
}
