/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.testutils;

import com.vaadin.hilla.parser.utils.JsonPrinter;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import tools.jackson.core.JacksonException;

public final class JsonAssertions {
    private static final JsonPrinter printer = new JsonPrinter();

    public static void assertEquals(Object expected, Object actual) throws JacksonException {
        String expectedJson = printer.writeAsString(expected);
        String actualJson = printer.writeAsString(actual);
        try {
            JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
        }
        catch (AssertionError | JSONException e) {
            String originalMessage = ((Throwable)e).getMessage();
            String enhancedMessage = JsonAssertions.enhanceErrorMessage(originalMessage, expectedJson, actualJson);
            throw new AssertionError(enhancedMessage, (Throwable)e);
        }
    }

    private static String enhanceErrorMessage(String originalMessage, String expectedJson, String actualJson) throws JacksonException {
        StringBuilder enhanced = new StringBuilder();
        enhanced.append("JSON comparison failed:\n");
        enhanced.append(originalMessage);
        enhanced.append("\n\nFor better context, here are the complete JSON structures:\n\n");
        enhanced.append("Expected:\n");
        enhanced.append(expectedJson);
        enhanced.append("\n\nActual:\n");
        enhanced.append(actualJson);
        return enhanced.toString();
    }
}

