/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone;

import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.RootNode;
import com.vaadin.hilla.parser.models.ArraySignatureModel;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.MethodInfoModel;
import com.vaadin.hilla.parser.models.MethodParameterInfoModel;
import com.vaadin.hilla.parser.models.ReflectionSignatureModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.models.SpecializedModel;
import com.vaadin.hilla.parser.models.TypeArgumentModel;
import com.vaadin.hilla.parser.models.TypeParameterModel;
import com.vaadin.hilla.parser.models.TypeVariableModel;
import com.vaadin.hilla.parser.models.jackson.JacksonPropertyModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.SchemaProcessor;
import com.vaadin.hilla.parser.plugins.backbone.nodes.CompositeTypeSignatureNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EntityNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.MethodNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.MethodParameterNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.PropertyNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypeSignatureNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import com.vaadin.hilla.parser.utils.Generics;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class TypeSignaturePlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    public void enter(NodePath<?> nodePath) {
        if (nodePath.getNode() instanceof TypedNode) {
            ClassRefSignatureModel signature;
            TypedNode typedNode = (TypedNode)nodePath.getNode();
            Schema<?> schema = new SchemaProcessor(typedNode.getType(), this.isInEntity(nodePath)).process();
            if (!(!(typedNode.getType() instanceof ClassRefSignatureModel) || (signature = (ClassRefSignatureModel)typedNode.getType()).isIterable() || signature.isMap() || signature.isOptional() || signature.getTypeArguments().isEmpty())) {
                schema.addExtension("x-type-arguments", (Object)new ComposedSchema());
            }
            typedNode.setTarget(schema);
        }
    }

    private boolean isInEntity(NodePath<?> nodePath) {
        NodePath np = nodePath;
        while (!(np.getNode() instanceof RootNode)) {
            if (np.getNode() instanceof EntityNode) {
                return true;
            }
            np = np.getParentPath();
        }
        return false;
    }

    public void exit(NodePath<?> nodePath) {
        if (!(nodePath.getNode() instanceof TypedNode)) {
            return;
        }
        TypedNode node = (TypedNode)nodePath.getNode();
        Schema<?> schema = node.getTarget();
        Node parentNode = nodePath.getParentPath().getNode();
        Node grandParentNode = nodePath.getParentPath().getParentPath().getNode();
        if (parentNode instanceof MethodNode) {
            this.attachSchemaToMethod(schema, (MethodNode)parentNode);
        } else if (parentNode instanceof MethodParameterNode && grandParentNode instanceof MethodNode) {
            this.attachSchemaToParameterOfMethod(schema, (MethodParameterNode)parentNode, (MethodNode)grandParentNode);
        } else if (parentNode instanceof EntityNode && schema instanceof ComposedSchema) {
            this.attachSchemaToEntitySubclass((ComposedSchema)schema, (EntityNode)parentNode);
        } else if (parentNode instanceof PropertyNode && grandParentNode instanceof EntityNode) {
            this.attachSchemaToPropertyOfEntity(schema, (PropertyNode)parentNode, (EntityNode)grandParentNode);
        } else if (parentNode instanceof TypedNode) {
            this.attachSchemaToNestingParentSignature(schema, (TypedNode)parentNode);
        }
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        Node node = nodeDependencies.getNode();
        if (node instanceof MethodNode) {
            return this.scanMethodNode((MethodNode)node, nodeDependencies);
        }
        if (node instanceof MethodParameterNode) {
            return this.scanMethodParameter((MethodParameterNode)node, nodeDependencies);
        }
        if (node instanceof EntityNode) {
            return this.scanEntity((EntityNode)node, nodeDependencies);
        }
        if (node instanceof PropertyNode) {
            return this.scanProperty((PropertyNode)node, nodeDependencies);
        }
        if (node instanceof CompositeTypeSignatureNode) {
            return this.scanCompositeTypeSignature((CompositeTypeSignatureNode)node, nodeDependencies);
        }
        if (node instanceof TypeSignatureNode) {
            return this.scanTypeSignature((TypeSignatureNode)node, nodeDependencies);
        }
        return nodeDependencies;
    }

    private void attachSchemaToEntitySubclass(ComposedSchema schema, EntityNode entityNode) {
        Schema subclassSchema = (Schema)entityNode.getTarget();
        schema.addAnyOfItem(subclassSchema);
        schema.setNullable(null);
        entityNode.setTarget(schema);
    }

    private void attachSchemaToMethod(Schema<?> schema, MethodNode methodNode) {
        ((ApiResponse)((PathItem)methodNode.getTarget()).getPost().getResponses().get((Object)"200")).setContent(new Content().addMediaType("application/json", new MediaType().schema(schema)));
    }

    private void attachSchemaToNestingParentSignature(Schema<?> schema, TypedNode parentNode) {
        Schema<?> parentSchema = parentNode.getTarget();
        if (parentSchema instanceof ArraySchema) {
            ((ArraySchema)parentSchema).setItems(schema);
        } else if (parentSchema instanceof MapSchema) {
            parentSchema.additionalProperties(schema);
        } else if (parentSchema.getExtensions() != null && parentSchema.getExtensions().get("x-type-arguments") != null) {
            ((ComposedSchema)parentSchema.getExtensions().get("x-type-arguments")).addAllOfItem(schema);
        } else {
            parentNode.setTarget(schema);
        }
    }

    private void attachSchemaToParameterOfMethod(Schema<?> schema, MethodParameterNode methodParameterNode, MethodNode methodNode) {
        ObjectSchema requestMap = (ObjectSchema)((MediaType)((PathItem)methodNode.getTarget()).getPost().getRequestBody().getContent().get((Object)"application/json")).getSchema();
        requestMap.addProperties((String)methodParameterNode.getTarget(), schema);
    }

    private void attachSchemaToPropertyOfEntity(Schema<?> schema, PropertyNode propertyNode, EntityNode entityNode) {
        String propertyName = (String)propertyNode.getTarget();
        ((Schema)entityNode.getTarget()).addProperties(propertyName, schema);
    }

    private List<SignatureModel> getReferredTypes(SignatureModel signature) {
        List<Object> items = List.of();
        if (signature.isArray()) {
            items = List.of(((ArraySignatureModel)signature).getNestedType());
        } else if (signature.isIterable()) {
            List typeArguments = ((ClassRefSignatureModel)signature).getTypeArguments();
            if (!typeArguments.isEmpty()) {
                items = List.of((SignatureModel)typeArguments.get(0));
            } else {
                Class cls = (Class)((ClassRefSignatureModel)signature).getClassInfo().get();
                items = Generics.getExactIterableType((Class)cls).map(type -> List.of(SignatureModel.of((AnnotatedElement)((AnnotatedElement)((Object)type))))).orElse(items);
            }
        } else if (signature.isOptional()) {
            List typeArguments = ((ClassRefSignatureModel)signature).getTypeArguments();
            if (!typeArguments.isEmpty()) {
                items = List.of((SignatureModel)typeArguments.get(0));
            }
        } else if (signature.isMap()) {
            List typeArguments = ((ClassRefSignatureModel)signature).getTypeArguments();
            if (!typeArguments.isEmpty()) {
                items = List.of((SignatureModel)typeArguments.get(1));
            }
        } else if (signature.isTypeArgument()) {
            List associatedTypes = ((TypeArgumentModel)signature).getAssociatedTypes();
            if (!associatedTypes.isEmpty()) {
                items = List.of((SignatureModel)associatedTypes.get(0));
            }
        } else if (signature.isTypeParameter()) {
            List bounds = ((TypeParameterModel)signature).getBounds();
            if (!bounds.isEmpty()) {
                items = bounds.stream().filter(Objects::nonNull).filter(Predicate.not(SpecializedModel::isNativeObject)).collect(Collectors.toList());
            }
        } else if (signature.isTypeVariable()) {
            items = List.of(((TypeVariableModel)signature).resolve());
        } else if (signature.isClassRef()) {
            items = ((ClassRefSignatureModel)signature).getTypeArguments().stream().map(SignatureModel.class::cast).toList();
        }
        return items;
    }

    private List<SignatureModel> filterCompatible(List<SignatureModel> types) {
        if (types.isEmpty()) {
            return types;
        }
        String primary = this.signatureToTypeString(types.get(0));
        return types.stream().filter(type -> primary.equals(this.signatureToTypeString((SignatureModel)type))).collect(Collectors.toList());
    }

    private NodeDependencies scanCompositeTypeSignature(CompositeTypeSignatureNode node, NodeDependencies nodeDependencies) {
        List types = (List)node.getSource();
        List<SignatureModel> referredTypes = types.stream().map(this::getReferredTypes).flatMap(Collection::stream).collect(Collectors.toList());
        return this.scanTypes(referredTypes, nodeDependencies);
    }

    private NodeDependencies scanEntity(EntityNode node, NodeDependencies nodeDependencies) {
        ClassInfoModel cls = (ClassInfoModel)node.getSource();
        if (cls.getSuperClass().isPresent() && ((ClassRefSignatureModel)cls.getSuperClass().get()).isNonJDKClass()) {
            return nodeDependencies.appendChildNodes(Stream.of(TypeSignatureNode.of((SignatureModel)cls.getSuperClass().get())));
        }
        return nodeDependencies;
    }

    private NodeDependencies scanMethodNode(MethodNode methodNode, NodeDependencies nodeDependencies) {
        if (((MethodInfoModel)methodNode.getSource()).getResultType().isVoid()) {
            return nodeDependencies;
        }
        TypeSignatureNode resultTypeNode = TypeSignatureNode.of(((MethodInfoModel)methodNode.getSource()).getResultType());
        return nodeDependencies.appendChildNodes(Stream.of(resultTypeNode));
    }

    private NodeDependencies scanMethodParameter(MethodParameterNode methodParameterNode, NodeDependencies nodeDependencies) {
        return nodeDependencies.appendChildNodes(Stream.of(TypeSignatureNode.of(((MethodParameterInfoModel)methodParameterNode.getSource()).getType())));
    }

    private NodeDependencies scanProperty(PropertyNode propertyNode, NodeDependencies nodeDependencies) {
        JacksonPropertyModel property = (JacksonPropertyModel)propertyNode.getSource();
        List types = property.getAssociatedTypes();
        return this.scanTypes(types, nodeDependencies);
    }

    private NodeDependencies scanTypes(List<SignatureModel> types, NodeDependencies nodeDependencies) {
        if ((types = this.filterCompatible(types)).size() > 1) {
            return nodeDependencies.appendChildNodes(Stream.of(CompositeTypeSignatureNode.of(types)));
        }
        return nodeDependencies.appendChildNodes(types.stream().map(TypeSignatureNode::of));
    }

    private NodeDependencies scanTypeSignature(TypeSignatureNode node, NodeDependencies nodeDependencies) {
        SignatureModel signature = (SignatureModel)node.getSource();
        if (signature instanceof ClassRefSignatureModel) {
            ClassRefSignatureModel classModel = (ClassRefSignatureModel)signature;
            nodeDependencies = nodeDependencies.appendChildNodes(classModel.getTypeArguments().stream().map(TypeSignatureNode::of));
        }
        List<SignatureModel> referredTypes = this.getReferredTypes(signature);
        return nodeDependencies.appendChildNodes(referredTypes.stream().map(TypeSignatureNode::of));
    }

    private String signatureToTypeString(SignatureModel type) {
        AnnotatedElement annotatedElement = ((ReflectionSignatureModel)type).get();
        if (annotatedElement instanceof AnnotatedType) {
            return ((AnnotatedType)annotatedElement).getType().getTypeName();
        }
        if (annotatedElement instanceof Type) {
            return ((Type)((Object)annotatedElement)).getTypeName();
        }
        return annotatedElement.toString();
    }
}

