/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.GeneratorConfiguration;
import com.vaadin.hilla.engine.GeneratorException;
import com.vaadin.hilla.engine.GeneratorShellRunner;
import com.vaadin.hilla.engine.commandrunner.CommandNotFoundException;
import com.vaadin.hilla.engine.commandrunner.CommandRunnerException;
import com.vaadin.hilla.parser.core.OpenAPIFileType;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorProcessor {
    public static String GENERATED_FILE_LIST_NAME = "generated-file-list.txt";
    private static final Logger logger = LoggerFactory.getLogger(GeneratorProcessor.class);
    private static final Path TSGEN_PATH = Paths.get("node_modules", "@vaadin", "hilla-generator-cli", "bin", "index.js");
    private final Path baseDir;
    private final String nodeCommand;
    private final Path openAPIFile;
    private final Path outputDirectory;
    private final GeneratorConfiguration.PluginsProcessor pluginsProcessor = new GeneratorConfiguration.PluginsProcessor();

    public GeneratorProcessor(EngineConfiguration conf) {
        this.baseDir = conf.getBaseDir();
        this.openAPIFile = conf.getOpenAPIFile();
        this.outputDirectory = conf.getOutputDir();
        this.nodeCommand = conf.getNodeCommand();
        this.applyConfiguration(conf.getGenerator());
    }

    public void process() throws GeneratorException {
        if (this.isOpenAPIEmpty()) {
            this.cleanup();
            return;
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(TSGEN_PATH);
        this.prepareOutputDir(arguments);
        this.preparePlugins(arguments);
        this.prepareVerbose(arguments);
        try {
            GeneratorShellRunner runner = new GeneratorShellRunner(this.baseDir.toFile(), this.nodeCommand, (String[])arguments.stream().map(Objects::toString).toArray(String[]::new));
            runner.run(stdIn -> {
                try {
                    Files.copy(this.openAPIFile, stdIn);
                }
                catch (IOException e) {
                    throw new LambdaException(e);
                }
            });
        }
        catch (LambdaException e) {
            throw new GeneratorException("Node execution failed", e.getCause());
        }
        catch (CommandNotFoundException e) {
            throw new GeneratorException("Node command not found", e);
        }
        catch (CommandRunnerException e) {
            throw new GeneratorException("Node execution failed", e);
        }
    }

    private void cleanup() throws GeneratorException {
        Path generatedFilesListFile = this.outputDirectory.resolve(GENERATED_FILE_LIST_NAME);
        if (!generatedFilesListFile.toFile().exists()) {
            logger.debug("Generated file list file does not exist, skipping cleanup.");
            return;
        }
        logger.debug("Cleaning up old output.");
        List<Object> generatedFilesList = List.of();
        try {
            generatedFilesList = Files.readAllLines(generatedFilesListFile);
        }
        catch (IOException e) {
            throw new GeneratorException("Unable to read generated file list file", e);
        }
        try {
            for (String string : generatedFilesList) {
                Path path = this.outputDirectory.resolve(string);
                logger.debug("Removing generated file: {}", (Object)path);
                Files.deleteIfExists(path);
                Path dir = path.getParent();
                while (dir.startsWith(this.outputDirectory) && !dir.equals(this.outputDirectory) && Files.isDirectory(dir, new LinkOption[0]) && Objects.requireNonNull(dir.toFile().list()).length == 0) {
                    logger.debug("Removing unused generated directory: {}", (Object)dir);
                    Files.deleteIfExists(dir);
                }
            }
        }
        catch (IOException e) {
            throw new GeneratorException("Unable to cleanup generated files", e);
        }
        try {
            Files.deleteIfExists(generatedFilesListFile);
        }
        catch (IOException e) {
            throw new GeneratorException("Unable to remove the generated file list file", e);
        }
    }

    private GeneratorProcessor applyConfiguration(GeneratorConfiguration generatorConfiguration) {
        if (generatorConfiguration == null) {
            return this;
        }
        generatorConfiguration.getPlugins().ifPresent(this::applyPlugins);
        return this;
    }

    private void applyPlugins(@NonNull GeneratorConfiguration.Plugins plugins) {
        this.pluginsProcessor.setConfig(plugins);
    }

    private void prepareOutputDir(List<Object> arguments) {
        Path result = this.outputDirectory.isAbsolute() ? this.outputDirectory : this.baseDir.resolve(this.outputDirectory);
        arguments.add("-o");
        arguments.add(result);
    }

    private void preparePlugins(List<Object> arguments) {
        this.pluginsProcessor.process().stream().map(GeneratorConfiguration.Plugin::getPath).distinct().forEachOrdered(path -> {
            arguments.add("-p");
            arguments.add(path);
        });
    }

    private void prepareVerbose(List<Object> arguments) {
        if (logger.isDebugEnabled()) {
            arguments.add("-v");
        }
    }

    private OpenAPI getOpenAPI() throws IOException {
        String source = Files.readString(this.openAPIFile);
        ObjectMapper mapper = OpenAPIFileType.JSON.getMapper();
        ObjectReader reader = mapper.reader();
        return (OpenAPI)reader.readValue(source, OpenAPI.class);
    }

    private boolean isOpenAPIEmpty() {
        try {
            OpenAPI openApi = this.getOpenAPI();
            return !(openApi.getPaths() != null && !openApi.getPaths().isEmpty() || openApi.getComponents() != null && openApi.getComponents().getSchemas() != null && !openApi.getComponents().getSchemas().isEmpty());
        }
        catch (IOException e) {
            throw new GeneratorException("Unable to read OpenAPI json file", e);
        }
    }

    private static class LambdaException
    extends RuntimeException {
        public LambdaException(Throwable cause) {
            super(cause);
        }
    }
}

