/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.hilla.ApplicationContextProvider;
import com.vaadin.hilla.BrowserCallable;
import com.vaadin.hilla.Endpoint;
import com.vaadin.hilla.EndpointController;
import com.vaadin.hilla.OpenAPIUtil;
import com.vaadin.hilla.engine.EngineAutoConfiguration;
import com.vaadin.hilla.engine.GeneratorProcessor;
import com.vaadin.hilla.engine.ParserProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class EndpointCodeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointCodeGenerator.class);
    private final EndpointController endpointController;
    private final VaadinContext context;
    private ApplicationConfiguration configuration;
    private Set<String> classesUsedInOpenApi = null;
    private EngineAutoConfiguration engineConfiguration;

    public EndpointCodeGenerator(VaadinContext context, EndpointController endpointController) {
        this.endpointController = endpointController;
        this.context = context;
    }

    public static EndpointCodeGenerator getInstance() {
        return (EndpointCodeGenerator)ApplicationContextProvider.getApplicationContext().getBean(EndpointCodeGenerator.class);
    }

    public void update(String ... proposedNewBrowserCallables) {
        this.initIfNeeded();
        if (this.configuration.isProductionMode()) {
            throw new IllegalStateException("This method is not available in production mode");
        }
        ApplicationContextProvider.runOnContext(applicationContext -> {
            List<Class<?>> browserCallables = EndpointCodeGenerator.findBrowserCallables(this.engineConfiguration, applicationContext);
            browserCallables = Stream.concat(browserCallables.stream(), Arrays.stream(proposedNewBrowserCallables).map(className -> {
                try {
                    Class<?> cls = Class.forName(className);
                    if (cls.getAnnotation(Endpoint.class) != null || cls.getAnnotation(BrowserCallable.class) != null) {
                        return cls;
                    }
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Unable to find class " + className, (Throwable)e);
                }
                return null;
            })).filter(Objects::nonNull).distinct().toList();
            ParserProcessor parser = new ParserProcessor(this.engineConfiguration);
            parser.process(browserCallables);
            GeneratorProcessor generator = new GeneratorProcessor(this.engineConfiguration);
            generator.process();
            this.endpointController.registerEndpoints();
        });
    }

    public static List<Class<?>> findBrowserCallables(EngineAutoConfiguration engineConfiguration, ApplicationContext applicationContext) {
        return engineConfiguration.getEndpointAnnotations().stream().map(arg_0 -> ((ApplicationContext)applicationContext).getBeansWithAnnotation(arg_0)).map(Map::values).flatMap(Collection::stream).map(AopProxyUtils::ultimateTargetClass).distinct().collect(Collectors.toList());
    }

    private void initIfNeeded() {
        if (this.configuration == null) {
            this.configuration = ApplicationConfiguration.get((VaadinContext)this.context);
            FrontendTools frontendTools = new FrontendTools(this.configuration, this.configuration.getProjectFolder());
            this.engineConfiguration = new EngineAutoConfiguration.Builder().baseDir(this.configuration.getProjectFolder().toPath()).buildDir(this.configuration.getBuildFolder()).outputDir(FrontendUtils.getFrontendGeneratedFolder((File)this.configuration.getFrontendFolder()).toPath()).productionMode(false).withDefaultAnnotations().nodeCommand(frontendTools.getNodeBinary()).build();
        }
    }

    public Optional<Set<String>> getClassesUsedInOpenApi() throws IOException {
        if (this.classesUsedInOpenApi == null) {
            this.initIfNeeded();
            EngineAutoConfiguration conf = EngineAutoConfiguration.getDefault();
            Path openApiPath = conf.getOpenAPIFile();
            if (openApiPath != null && openApiPath.toFile().exists()) {
                try {
                    this.classesUsedInOpenApi = OpenAPIUtil.findOpenApiClasses(Files.readString(openApiPath));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                LOGGER.debug("No OpenAPI file is available yet ...");
            }
        }
        return Optional.ofNullable(this.classesUsedInOpenApi);
    }
}

