/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.signals.Signal;
import com.vaadin.hilla.signals.core.event.InvalidEventTypeException;
import com.vaadin.hilla.signals.core.event.MissingFieldException;
import com.vaadin.hilla.signals.core.event.StateEvent;
import com.vaadin.hilla.signals.operation.OperationValidator;
import com.vaadin.hilla.signals.operation.ReplaceValueOperation;
import com.vaadin.hilla.signals.operation.SetValueOperation;
import com.vaadin.hilla.signals.operation.ValidationResult;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class ValueSignal<T>
extends Signal<T> {
    private T value;

    public ValueSignal(T defaultValue, Class<T> valueType) {
        this(valueType);
        this.value = Objects.requireNonNull(defaultValue);
    }

    public ValueSignal(Class<T> valueType) {
        super(valueType);
    }

    protected ValueSignal(ValueSignal<T> delegate) {
        super(delegate);
    }

    @Override
    protected ValueSignal<T> getDelegate() {
        return (ValueSignal)super.getDelegate();
    }

    @Override
    public Flux<ObjectNode> subscribe() {
        if (this.getDelegate() != null) {
            return ((ValueSignal)this.getDelegate()).subscribe();
        }
        return super.subscribe();
    }

    @Override
    public Flux<ObjectNode> subscribe(String signalId) {
        if (this.getDelegate() != null) {
            return ((ValueSignal)this.getDelegate()).subscribe(signalId);
        }
        return this.subscribe();
    }

    @Nullable
    public T getValue() {
        return this.getDelegate() != null ? ((ValueSignal)this.getDelegate()).getValue() : this.value;
    }

    @Override
    protected ObjectNode createSnapshotEvent() {
        if (this.getDelegate() != null) {
            return ((ValueSignal)this.getDelegate()).createSnapshotEvent();
        }
        StateEvent<T> snapshot = new StateEvent<T>(this.getId().toString(), StateEvent.EventType.SNAPSHOT, this.value);
        snapshot.setAccepted(true);
        return snapshot.toJson();
    }

    @Override
    protected ObjectNode processEvent(ObjectNode event) {
        try {
            StateEvent stateEvent = new StateEvent(event, this.getValueType());
            return switch (stateEvent.getEventType()) {
                case StateEvent.EventType.SET -> this.handleSetEvent(stateEvent);
                case StateEvent.EventType.REPLACE -> this.handleReplaceEvent(stateEvent);
                default -> throw new UnsupportedOperationException("Unsupported event: " + stateEvent.getEventType());
            };
        }
        catch (InvalidEventTypeException | MissingFieldException e) {
            throw new UnsupportedOperationException("Unsupported JSON: " + event, e);
        }
    }

    protected ObjectNode handleSetEvent(StateEvent<T> stateEvent) {
        if (this.getDelegate() != null) {
            return ((ValueSignal)this.getDelegate()).handleSetEvent(stateEvent);
        }
        this.value = stateEvent.getValue();
        stateEvent.setAccepted(true);
        return stateEvent.toJson();
    }

    protected ObjectNode handleReplaceEvent(StateEvent<T> stateEvent) {
        if (this.getDelegate() != null) {
            return ((ValueSignal)this.getDelegate()).handleReplaceEvent(stateEvent);
        }
        boolean accepted = this.compareAndSet(stateEvent.getValue(), stateEvent.getExpected());
        stateEvent.setAccepted(accepted);
        return stateEvent.toJson();
    }

    protected boolean compareAndSet(T newValue, T expectedValue) {
        if (Objects.equals(this.value, expectedValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    protected ObjectNode handleValidationResult(StateEvent<T> event, ValidationResult validationResult, Function<StateEvent<T>, ObjectNode> handler) {
        if (validationResult.isOk()) {
            return handler.apply(event);
        }
        event.setAccepted(false);
        event.setValidationError(validationResult.getErrorMessage());
        return event.toJson();
    }

    public ValueSignal<T> withOperationValidator(OperationValidator<T> validator) {
        Objects.requireNonNull(validator, "Validator cannot be null");
        return new ValidatedValueSignal<T>(this, validator);
    }

    @Override
    public ValueSignal<T> asReadonly() {
        return this.withOperationValidator(op -> ValidationResult.reject("Read-only signal does not allow any modifications"));
    }

    private static class ValidatedValueSignal<T>
    extends ValueSignal<T> {
        private final OperationValidator<T> validator;

        private ValidatedValueSignal(ValueSignal<T> delegate, OperationValidator<T> validator) {
            super(delegate);
            this.validator = validator;
        }

        @Override
        protected ObjectNode handleSetEvent(StateEvent<T> stateEvent) {
            SetValueOperation<T> operation = new SetValueOperation<T>(stateEvent.getId(), stateEvent.getValue());
            ValidationResult validation = this.validator.validate(operation);
            return this.handleValidationResult(stateEvent, validation, x$0 -> super.handleSetEvent(x$0));
        }

        @Override
        protected ObjectNode handleReplaceEvent(StateEvent<T> stateEvent) {
            ReplaceValueOperation<T> operation = new ReplaceValueOperation<T>(stateEvent.getId(), stateEvent.getExpected(), stateEvent.getValue());
            ValidationResult validation = this.validator.validate(operation);
            return this.handleValidationResult(stateEvent, validation, x$0 -> super.handleReplaceEvent(x$0));
        }
    }
}

