/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.hilla.EndpointProperties;
import com.vaadin.hilla.EndpointRegistry;
import com.vaadin.hilla.auth.EndpointAccessChecker;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

@Component
public class EndpointUtil
implements EndpointRequestUtil {
    @Autowired
    private EndpointProperties endpointProperties;
    @Autowired
    private EndpointRegistry registry;
    @Autowired
    private EndpointAccessChecker accessChecker;

    public boolean isEndpointRequest(HttpServletRequest request) {
        return this.getEndpoint(request).isPresent();
    }

    private Optional<Method> getEndpoint(HttpServletRequest request) {
        return this.getEndpointData(request).map(EndpointData::method);
    }

    public boolean isAnonymousEndpoint(HttpServletRequest request) {
        Optional<EndpointData> endpointData = this.getEndpointData(request);
        if (endpointData.isEmpty()) {
            return false;
        }
        Class invokedEndpointClass = ClassUtils.getUserClass((Object)endpointData.get().endpointObject());
        Class<?> methodDeclaringClass = endpointData.get().method().getDeclaringClass();
        if (methodDeclaringClass.equals(invokedEndpointClass)) {
            return this.accessChecker.getAccessAnnotationChecker().hasAccess(endpointData.get().method(), null, role -> false);
        }
        return this.accessChecker.getAccessAnnotationChecker().hasAccess(invokedEndpointClass, null, role -> false);
    }

    private Optional<PathPattern.PathMatchInfo> getPathMatchInfo(HttpServletRequest request) {
        PathPatternParser pathParser = new PathPatternParser();
        PathPattern pathPattern = pathParser.parse(this.endpointProperties.getEndpointPrefix() + "/{endpoint}/{method}");
        RequestPath requestPath = RequestPath.parse((String)request.getRequestURI(), (String)request.getContextPath());
        PathContainer pathWithinApplication = requestPath.pathWithinApplication();
        PathPattern.PathMatchInfo matchInfo = pathPattern.matchAndExtract(pathWithinApplication);
        return Optional.ofNullable(matchInfo);
    }

    private Optional<EndpointData> getEndpointData(HttpServletRequest request) {
        Optional<PathPattern.PathMatchInfo> matchInfo = this.getPathMatchInfo(request);
        if (matchInfo.isEmpty()) {
            return Optional.empty();
        }
        Map uriVariables = matchInfo.get().getUriVariables();
        String endpointName = (String)uriVariables.get("endpoint");
        String methodName = (String)uriVariables.get("method");
        EndpointRegistry.VaadinEndpointData data = this.registry.get(endpointName);
        if (data == null) {
            return Optional.empty();
        }
        Optional<Method> endpointMethod = data.getMethod(methodName);
        return endpointMethod.map(method -> new EndpointData((Method)method, data.getEndpointObject()));
    }

    private record EndpointData(Method method, Object endpointObject) {
    }
}

