/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.generator;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static String capitalize(String s) {
        return s == null ? s : s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static int compare(String s1, String s2) {
        return Objects.equals(s1, s2) ? 0 : (s1 == null ? -1 : (s2 == null ? 1 : s1.compareTo(s2)));
    }

    public static boolean contains(String s, String p) {
        return GeneratorUtils.isNotBlank(s) && GeneratorUtils.isNotBlank(p) && s.contains(p);
    }

    public static String firstNonBlank(String ... values) {
        return Arrays.stream(values).filter(GeneratorUtils::isNotBlank).findFirst().orElse(null);
    }

    public static boolean hasAnnotation(NodeWithAnnotations<?> declaration, CompilationUnit compilationUnit, Class<? extends Annotation> annotation) {
        Optional endpointAnnotation = declaration.getAnnotationByClass(annotation);
        if (endpointAnnotation.isPresent()) {
            return compilationUnit.getImports().stream().anyMatch(importDeclaration -> annotation.getName().equals(importDeclaration.getNameAsString()));
        }
        return false;
    }

    public static boolean isBlank(String s) {
        return s == null || s.replaceAll("\\s+", "").isEmpty();
    }

    public static boolean isNotBlank(String s) {
        return !GeneratorUtils.isBlank(s);
    }

    public static boolean isNotTrue(Boolean b) {
        return !GeneratorUtils.isTrue(b);
    }

    public static boolean isTrue(Boolean b) {
        return Boolean.TRUE.equals(b);
    }

    public static String removeEnd(String s, String p) {
        return s.endsWith(p) ? s.substring(0, s.lastIndexOf(p)) : s;
    }

    public static String replaceChars(String s, char c1, char c2) {
        return s == null ? s : s.replace(c1, c2);
    }

    public static String substringAfter(String s, String p) {
        return GeneratorUtils.contains(s, p) ? s.substring(s.indexOf(p) + p.length()) : "";
    }

    public static String substringAfterLast(String s, String p) {
        return GeneratorUtils.contains(s, p) ? s.substring(s.lastIndexOf(p) + p.length()) : "";
    }

    public static String substringBeforeLast(String s, String p) {
        return GeneratorUtils.contains(s, p) ? s.substring(0, s.lastIndexOf(p)) : s;
    }

    public static <P1, P2, R> Stream<R> zip(List<P1> first, List<P2> second, BiFunction<P1, P2, R> zipper) {
        return IntStream.range(0, Math.min(first.size(), second.size())).mapToObj(i -> zipper.apply(first.get(i), second.get(i)));
    }
}

