/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTaskFusionGenerator
implements FallibleCommand {
    private final File applicationProperties;

    AbstractTaskFusionGenerator(File applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    protected Properties readApplicationProperties() {
        Properties config = new Properties();
        if (this.applicationProperties != null && this.applicationProperties.exists()) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.applicationProperties.toPath(), StandardCharsets.UTF_8);){
                config.load(bufferedReader);
            }
            catch (IOException e) {
                this.log().info(String.format("Can't read the application.properties file from %s", this.applicationProperties.toString()), (Throwable)e);
            }
        } else {
            this.log().debug("Found no application properties, using default values.");
        }
        return config;
    }

    Logger log() {
        return LoggerFactory.getLogger(AbstractTaskFusionGenerator.class);
    }
}

