/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.endpointransfermapper;

import com.vaadin.fusion.endpointransfermapper.PageMapper;
import com.vaadin.fusion.endpointransfermapper.PageableMapper;
import com.vaadin.fusion.endpointransfermapper.UUIDMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointTransferMapper {
    private Map<Class<?>, Class<?>> endpointToTransfer = new HashMap();
    private Map<Class<?>, Mapper<?, ?>> mappers = new HashMap();

    public EndpointTransferMapper() {
        this.registerMapper(new PageableMapper());
        this.registerMapper(new UUIDMapper());
        this.registerMapper(new PageMapper());
    }

    private void registerMapper(Mapper<?, ?> mapper) {
        Class<?> endpointType = mapper.getEndpointType();
        this.endpointToTransfer.put(endpointType, mapper.getTransferType());
        this.mappers.put(endpointType, mapper);
    }

    public Class<?> getTransferType(Class<?> endpointType) {
        for (Map.Entry<Class<?>, Class<?>> entry : this.endpointToTransfer.entrySet()) {
            if (!entry.getKey().isAssignableFrom(endpointType)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getTransferType(String endpointType) {
        for (Map.Entry<Class<?>, Class<?>> entry : this.endpointToTransfer.entrySet()) {
            if (!entry.getKey().getName().equals(endpointType)) continue;
            return entry.getValue().getName();
        }
        return null;
    }

    public <T> Mapper getMapper(Class<T> endpointType) {
        for (Class<T> clazz : this.endpointToTransfer.keySet()) {
            if (!clazz.isAssignableFrom(endpointType)) continue;
            return this.mappers.get(clazz);
        }
        return null;
    }

    public Object toTransferType(Object endpointValue) {
        if (endpointValue == null) {
            return null;
        }
        Class<?> endpointValueType = endpointValue.getClass();
        Mapper mapper = this.getMapper(endpointValueType);
        if (mapper == null) {
            return endpointValue;
        }
        this.getLogger().info("Mapping from endpoint type (" + endpointValueType.getName() + ") to transfer type (" + mapper.getTransferType().getName() + ")");
        return mapper.toTransferType(endpointValue);
    }

    public <T> T toEndpointType(Object transferValue, Class<T> endpointType) {
        if (transferValue == null) {
            return null;
        }
        Mapper mapper = this.getMapper(endpointType);
        if (mapper == null) {
            return (T)transferValue;
        }
        this.getLogger().debug("Mapping from transfer type (" + transferValue.getClass().getName() + ") to endpoint type (" + endpointType.getName() + ")");
        return (T)mapper.toEndpointType(transferValue);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public static interface Mapper<ENDPOINTTYPE, TRANSFERTYPE> {
        public Class<? extends ENDPOINTTYPE> getEndpointType();

        public Class<? extends TRANSFERTYPE> getTransferType();

        public TRANSFERTYPE toTransferType(ENDPOINTTYPE var1);

        public ENDPOINTTYPE toEndpointType(TRANSFERTYPE var1);
    }
}

