/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.auth;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;

public class FusionAccessChecker {
    public static final String ACCESS_DENIED_MSG = "Access denied";
    public static final String ACCESS_DENIED_MSG_DEV_MODE = "Unauthorized access to Vaadin endpoint; to enable endpoint access use one of the following annotations: @AnonymousAllowed, @PermitAll, @RolesAllowed";
    private AccessAnnotationChecker accessAnnotationChecker;

    public FusionAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        this.accessAnnotationChecker = accessAnnotationChecker;
    }

    public String check(Method method, HttpServletRequest request) {
        if (this.accessAnnotationChecker.hasAccess(method, request)) {
            return null;
        }
        if (this.isDevMode()) {
            return ACCESS_DENIED_MSG_DEV_MODE;
        }
        return ACCESS_DENIED_MSG;
    }

    private boolean isDevMode() {
        VaadinService vaadinService = VaadinService.getCurrent();
        return vaadinService != null && !vaadinService.getDeploymentConfiguration().isProductionMode();
    }

    public AccessAnnotationChecker getAccessAnnotationChecker() {
        return this.accessAnnotationChecker;
    }
}

