/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion;

import com.vaadin.fusion.EndpointRegistry;
import com.vaadin.fusion.FusionEndpointProperties;
import com.vaadin.fusion.auth.FusionAccessChecker;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.stereotype.Component;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

@Component
public class EndpointUtil {
    @Autowired
    private FusionEndpointProperties endpointProperties;
    @Autowired
    private EndpointRegistry registry;
    @Autowired
    private FusionAccessChecker accessChecker;

    public boolean isEndpointRequest(HttpServletRequest request) {
        return this.getEndpoint(request).isPresent();
    }

    private Optional<Method> getEndpoint(HttpServletRequest request) {
        RequestPath requestPath;
        PathContainer pathWithinApplication;
        PathPatternParser pathParser = new PathPatternParser();
        PathPattern pathPattern = pathParser.parse(this.endpointProperties.getVaadinEndpointPrefix() + "/{endpoint}/{method}");
        PathPattern.PathMatchInfo matchInfo = pathPattern.matchAndExtract(pathWithinApplication = (requestPath = ServletRequestPathUtils.parseAndCache((HttpServletRequest)request)).pathWithinApplication());
        if (matchInfo == null) {
            return Optional.empty();
        }
        Map uriVariables = matchInfo.getUriVariables();
        String endpointName = (String)uriVariables.get("endpoint");
        String endpointMethod = (String)uriVariables.get("method");
        EndpointRegistry.VaadinEndpointData data = this.registry.get(endpointName);
        if (data == null) {
            return Optional.empty();
        }
        return data.getMethod(endpointMethod);
    }

    public boolean isAnonymousEndpoint(HttpServletRequest request) {
        Optional<Method> method = this.getEndpoint(request);
        if (!method.isPresent()) {
            return false;
        }
        return this.accessChecker.getAccessAnnotationChecker().hasAccess(method.get(), null, role -> false);
    }
}

