/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.generator;

import com.vaadin.fusion.generator.ClientAPIGenerator;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BarrelGenerator {
    public static final String BARREL_FILE_NAME = "endpoints";
    public static final String BARREL_NAME = "endpoints.ts";
    private static final Logger log = LoggerFactory.getLogger(ClientAPIGenerator.class);
    private final Path outputFilePath;

    BarrelGenerator(Path outputFolder) {
        this.outputFilePath = outputFolder.resolve(BARREL_NAME);
    }

    void generate(OpenAPI openAPI) {
        List tagList = openAPI.getTags();
        if (tagList == null || tagList.isEmpty()) {
            return;
        }
        String imports = tagList.stream().map(tag -> String.format("import * as %1$s from \"./%1$s\";", tag.getName())).collect(Collectors.joining("\n"));
        String exports = String.format("export {\n%s\n};", tagList.stream().map(tag -> String.format("  %s", tag.getName())).collect(Collectors.joining(",\n")));
        String content = String.format("%s\n\n%s", imports, exports);
        try {
            log.info("writing file {}", (Object)this.outputFilePath);
            FileUtils.writeStringToFile((File)this.outputFilePath.toFile(), (String)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String errorMessage = String.format("Error writing file at %s", this.outputFilePath.toString());
            log.error(errorMessage, (Object)this.outputFilePath, (Object)e);
        }
    }

    Path getOutputFilePath() {
        return this.outputFilePath;
    }
}

