/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.auth;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.fusion.auth.CsrfChecker;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;

public class VaadinConnectAccessChecker {
    public static final String ACCESS_DENIED_MSG = "Access denied";
    public static final String ACCESS_DENIED_MSG_DEV_MODE = "Unauthorized access to Vaadin endpoint; to enable endpoint access use one of the following annotations: @AnonymousAllowed, @PermitAll, @RolesAllowed";
    private CsrfChecker csrfChecker;
    private AccessAnnotationChecker accessAnnotationChecker;

    public VaadinConnectAccessChecker(AccessAnnotationChecker accessAnnotationChecker, CsrfChecker csrfChecker) {
        this.accessAnnotationChecker = accessAnnotationChecker;
        this.csrfChecker = csrfChecker;
    }

    public String check(Method method, HttpServletRequest request) {
        if (!this.csrfChecker.validateCsrfTokenInRequest(request)) {
            return ACCESS_DENIED_MSG;
        }
        if (this.accessAnnotationChecker.hasAccess(method, request)) {
            return null;
        }
        if (this.isDevMode()) {
            return ACCESS_DENIED_MSG_DEV_MODE;
        }
        return ACCESS_DENIED_MSG;
    }

    private boolean isDevMode() {
        VaadinService vaadinService = VaadinService.getCurrent();
        return vaadinService != null && !vaadinService.getDeploymentConfiguration().isProductionMode();
    }

    public void enableCsrf(boolean xsrfProtectionEnabled) {
        this.csrfChecker.setCsrfProtection(xsrfProtectionEnabled);
    }

    public AccessAnnotationChecker getAccessAnnotationChecker() {
        return this.accessAnnotationChecker;
    }
}

