/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.auth;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.fusion.auth.VaadinConnectAccessChecker;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfChecker {
    private boolean csrfProtectionEnabled = true;

    public boolean validateCsrfTokenInRequest(HttpServletRequest request) {
        if (!this.isCsrfProtectionEnabled()) {
            return true;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return true;
        }
        String csrfTokenInSession = (String)session.getAttribute(VaadinService.getCsrfTokenAttributeName());
        if (csrfTokenInSession == null) {
            if (CsrfChecker.getLogger().isInfoEnabled()) {
                CsrfChecker.getLogger().info("Unable to verify CSRF token for endpoint request, got null token in session");
            }
            return false;
        }
        String csrfTokenInRequest = request.getHeader("X-CSRF-Token");
        if (csrfTokenInRequest == null || !MessageDigest.isEqual(csrfTokenInSession.getBytes(StandardCharsets.UTF_8), csrfTokenInRequest.getBytes(StandardCharsets.UTF_8))) {
            if (CsrfChecker.getLogger().isInfoEnabled()) {
                CsrfChecker.getLogger().info("Invalid CSRF token in endpoint request");
            }
            return false;
        }
        return true;
    }

    public void setCsrfProtection(boolean csrfProtectionEnabled) {
        this.csrfProtectionEnabled = csrfProtectionEnabled;
    }

    public boolean isCsrfProtectionEnabled() {
        return this.csrfProtectionEnabled;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinConnectAccessChecker.class);
    }
}

