/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.connect;

import com.vaadin.flow.server.connect.EndpointRegistry;
import com.vaadin.flow.server.connect.VaadinEndpointProperties;
import com.vaadin.flow.server.connect.auth.VaadinConnectAccessChecker;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.stereotype.Component;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

@Component
public class EndpointUtil {
    @Autowired
    private VaadinEndpointProperties endpointProperties;
    @Autowired
    private EndpointRegistry registry;
    @Autowired
    private VaadinConnectAccessChecker accessChecker;

    public boolean isEndpointRequest(HttpServletRequest request) {
        return this.getEndpoint(request).isPresent();
    }

    private Optional<Method> getEndpoint(HttpServletRequest request) {
        RequestPath requestPath;
        PathPatternParser pathParser = new PathPatternParser();
        PathPattern pathPattern = pathParser.parse(this.endpointProperties.getVaadinEndpointPrefix() + "/{endpoint}/{method}");
        if (pathPattern.matches((PathContainer)(requestPath = ServletRequestPathUtils.parseAndCache((HttpServletRequest)request)))) {
            PathPattern.PathMatchInfo matchInfo = pathPattern.matchAndExtract((PathContainer)requestPath);
            if (matchInfo == null) {
                return Optional.empty();
            }
            Map uriVariables = matchInfo.getUriVariables();
            String endpointName = (String)uriVariables.get("endpoint");
            String endpointMethod = (String)uriVariables.get("method");
            EndpointRegistry.VaadinEndpointData data = this.registry.get(endpointName);
            if (data == null) {
                return Optional.empty();
            }
            return data.getMethod(endpointMethod);
        }
        return Optional.empty();
    }

    public boolean isAnonymousEndpoint(HttpServletRequest request) {
        Optional<Method> method = this.getEndpoint(request);
        if (!method.isPresent()) {
            return false;
        }
        return this.accessChecker.getAccessAnnotationChecker().hasAccess(method.get(), null, role -> false);
    }
}

