/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.push;

import dev.hilla.ConditionalOnFeatureFlag;
import io.socket.engineio.server.EngineIoServer;
import io.socket.engineio.server.EngineIoWebSocket;
import io.socket.engineio.server.utils.ParseQS;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.server.HandshakeInterceptor;
import reactor.core.scheduler.Schedulers;

@Controller
@ConditionalOnFeatureFlag(value="hillaPush")
public final class EngineIoHandler
implements HandshakeInterceptor,
WebSocketHandler {
    private static final String ATTRIBUTE_ENGINEIO_BRIDGE = "engineIo.bridge";
    private static final String ATTRIBUTE_ENGINEIO_QUERY = "engineIo.query";
    private static final String ATTRIBUTE_ENGINEIO_HEADERS = "engineIo.headers";
    private final EngineIoServer mEngineIoServer;

    public EngineIoHandler(EngineIoServer engineIoServer) {
        this.mEngineIoServer = engineIoServer;
    }

    @RequestMapping(value={"/HILLA/push"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.OPTIONS}, headers={"Connection!=Upgrade"})
    public void httpHandler(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.mEngineIoServer.handleRequest(request, response);
    }

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        attributes.put(ATTRIBUTE_ENGINEIO_QUERY, request.getURI().getQuery());
        attributes.put(ATTRIBUTE_ENGINEIO_HEADERS, request.getHeaders());
        return true;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    public void afterConnectionEstablished(WebSocketSession webSocketSession) {
        EngineIoSpringWebSocket webSocket = new EngineIoSpringWebSocket(webSocketSession);
        webSocketSession.getAttributes().put(ATTRIBUTE_ENGINEIO_BRIDGE, webSocket);
        this.mEngineIoServer.handleWebSocket((EngineIoWebSocket)webSocket);
    }

    public void afterConnectionClosed(WebSocketSession webSocketSession, CloseStatus closeStatus) {
        ((EngineIoSpringWebSocket)((Object)webSocketSession.getAttributes().get(ATTRIBUTE_ENGINEIO_BRIDGE))).afterConnectionClosed(closeStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(WebSocketSession webSocketSession, WebSocketMessage<?> webSocketMessage) {
        Principal p = webSocketSession.getPrincipal();
        SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl((Authentication)p));
        try {
            ((EngineIoSpringWebSocket)((Object)webSocketSession.getAttributes().get(ATTRIBUTE_ENGINEIO_BRIDGE))).handleMessage(webSocketMessage);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    public void handleTransportError(WebSocketSession webSocketSession, Throwable throwable) {
        ((EngineIoSpringWebSocket)((Object)webSocketSession.getAttributes().get(ATTRIBUTE_ENGINEIO_BRIDGE))).handleTransportError(throwable);
    }

    public void cleanup() {
        this.mEngineIoServer.shutdown();
        Schedulers.shutdownNow();
    }

    private static final class EngineIoSpringWebSocket
    extends EngineIoWebSocket {
        private final WebSocketSession mSession;
        private final Map<String, String> mQuery;
        private final Map<String, List<String>> mHeaders;

        EngineIoSpringWebSocket(WebSocketSession session) {
            this.mSession = session;
            String queryString = (String)this.mSession.getAttributes().get(EngineIoHandler.ATTRIBUTE_ENGINEIO_QUERY);
            this.mQuery = queryString != null ? ParseQS.decode((String)queryString) : new HashMap<String, String>();
            this.mHeaders = (Map)this.mSession.getAttributes().get(EngineIoHandler.ATTRIBUTE_ENGINEIO_HEADERS);
        }

        public Map<String, String> getQuery() {
            return this.mQuery;
        }

        public void write(String message) throws IOException {
            this.mSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
        }

        public void write(byte[] message) throws IOException {
            this.mSession.sendMessage((WebSocketMessage)new BinaryMessage(message));
        }

        public void close() {
            try {
                this.mSession.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void afterConnectionClosed(CloseStatus closeStatus) {
            this.emit("close", new Object[0]);
        }

        void handleMessage(WebSocketMessage<?> message) {
            if (!(message.getPayload() instanceof String) && !(message.getPayload() instanceof byte[])) {
                throw new RuntimeException(String.format("Invalid message type received: %s. Expected String or byte[].", message.getPayload().getClass().getName()));
            }
            this.emit("message", new Object[]{message.getPayload()});
        }

        void handleTransportError(Throwable exception) {
            this.emit("error", new Object[]{"write error", exception.getMessage()});
        }

        public Map<String, List<String>> getConnectionHeaders() {
            return this.mHeaders;
        }
    }
}

