/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator;

import dev.hilla.generator.BarrelGenerator;
import dev.hilla.generator.ClientAPIGenerator;
import dev.hilla.generator.GenerationOutputDirectory;
import dev.hilla.generator.OpenAPIParser;
import dev.hilla.generator.typescript.CodeGenerator;
import io.swagger.codegen.v3.config.CodegenConfigurator;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class MainGenerator {
    public static final String MODEL = "Model";
    public static final String OPTIONAL_SUFFIX = " | undefined";
    public static final String TS = ".ts";
    public static final String MODEL_TS = "Model.ts";
    private final BarrelGenerator barrelGenerator;
    private final ClientAPIGenerator clientGenerator;
    private final GenerationOutputDirectory outputDirectory;
    private final OpenAPIParser parser;

    public MainGenerator(File openApiJsonFile, File outputDirectory) {
        this(openApiJsonFile, outputDirectory, null, null);
    }

    public MainGenerator(File openApiJsonFile, File outputDirectory, Properties properties) {
        this(openApiJsonFile, outputDirectory, properties, null);
    }

    public MainGenerator(File openApiJsonFile, File outputDirectory, String defaultClientPath) {
        this(openApiJsonFile, outputDirectory, null, defaultClientPath);
    }

    public MainGenerator(File openApiJsonFile, File outputDirectory, Properties properties, String defaultClientPath) {
        Objects.requireNonNull(openApiJsonFile);
        Objects.requireNonNull(outputDirectory);
        this.outputDirectory = new GenerationOutputDirectory(outputDirectory);
        this.parser = openApiJsonFile.exists() ? new OpenAPIParser(openApiJsonFile, this.outputDirectory, CodeGenerator.class, defaultClientPath) : null;
        this.clientGenerator = properties != null ? new ClientAPIGenerator(this.outputDirectory.toPath(), properties) : null;
        this.barrelGenerator = new BarrelGenerator(this.outputDirectory.toPath());
    }

    public void start() {
        if (this.parser == null) {
            this.outputDirectory.clean();
            return;
        }
        try {
            OpenAPI openAPI = this.parser.parseOpenAPI();
            boolean hasGeneratedSuccessfully = this.generateTypescriptCode(openAPI);
            if (this.clientGenerator != null && hasGeneratedSuccessfully) {
                this.clientGenerator.generate();
                this.barrelGenerator.generate(openAPI);
            }
        }
        catch (IllegalStateException e) {
            this.outputDirectory.clean();
            throw e;
        }
    }

    private boolean generateTypescriptCode(OpenAPI openAPI) {
        CodegenConfigurator configurator = this.parser.getConfigurator();
        Set<File> files = CodeGenerator.generateFiles(configurator.toClientOptInput().openAPI(openAPI));
        this.outputDirectory.clean(files);
        return files.stream().anyMatch(file -> file.getName().endsWith(TS));
    }
}

