/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator;

import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAPIGenerator {
    static final String DEFAULT_PREFIX = "/connect";
    static final String DEFAULT_URL_MAPPING = "/*";
    static final String PREFIX = "vaadin.endpoint.prefix";
    static final String URL_MAPPING = "vaadin.urlMapping";
    private static final String CLIENT_FILE_NAME = "connect-client.default";
    public static final String CONNECT_CLIENT_IMPORT_PATH = "./connect-client.default";
    public static final String CONNECT_CLIENT_NAME = "connect-client.default.ts";
    private static final String CUSTOM_CLIENT_FILE_NAME = "connect-client";
    public static final String CUSTOM_CONNECT_CLIENT_NAME = "connect-client.ts";
    private static final Logger logger = LoggerFactory.getLogger(ClientAPIGenerator.class);
    private final String endpointPrefix;
    private final Path outputFilePath;

    public ClientAPIGenerator(Path outputDirectory, Properties applicationProperties) {
        String prefix = (String)applicationProperties.getOrDefault((Object)PREFIX, DEFAULT_PREFIX);
        String urlMapping = (String)applicationProperties.getOrDefault((Object)URL_MAPPING, DEFAULT_URL_MAPPING);
        this.outputFilePath = Paths.get(outputDirectory.toAbsolutePath().toString(), CONNECT_CLIENT_NAME);
        this.endpointPrefix = this.relativizeEndpointPrefixWithUrlMapping(prefix, urlMapping);
    }

    public void generate() {
        String generatedDefaultClientTs = this.getDefaultClientTsTemplate().replace("{{PREFIX}}", this.endpointPrefix);
        try {
            logger.debug("writing file {}", (Object)this.outputFilePath);
            FileUtils.writeStringToFile((File)this.outputFilePath.toFile(), (String)generatedDefaultClientTs, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String errorMessage = String.format("Error writing file at %s", this.outputFilePath.toString());
            logger.error(errorMessage, (Object)this.outputFilePath, (Object)e);
        }
    }

    private String getDefaultClientTsTemplate() {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("connect-client.default.template.ts"), StandardCharsets.UTF_8));
        try {
            string = bufferedReader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read connect-client.default.template.ts", e);
            }
        }
        bufferedReader.close();
        return string;
    }

    public Path getOutputFilePath() {
        return this.outputFilePath;
    }

    final String relativizeEndpointPrefixWithUrlMapping(String endpointPrefix, String urlMapping) {
        urlMapping = this.removeTrailingStar(urlMapping);
        endpointPrefix = this.removeTrailingStar(endpointPrefix);
        Path urlMappingPath = Paths.get(urlMapping, new String[0]).normalize();
        Path endpointPrefixPath = Paths.get(endpointPrefix, new String[0]).normalize();
        return FrontendUtils.getUnixRelativePath((Path)urlMappingPath, (Path)endpointPrefixPath);
    }

    private String removeTrailingStar(String original) {
        if (original != null && original.endsWith(DEFAULT_URL_MAPPING)) {
            return original.substring(0, original.length() - 1);
        }
        return original;
    }
}

