/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public interface ClassLoaderAwareServletContainerInitializer
extends ServletContainerInitializer {
    default public void onStartup(Set<Class<?>> set, ServletContext ctx) throws ServletException {
        ClassLoader webClassLoader = ctx.getClassLoader();
        boolean noHack = false;
        for (ClassLoader classLoader = this.getClass().getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!classLoader.equals(webClassLoader)) continue;
            noHack = true;
            break;
        }
        if (noHack) {
            this.process(set, ctx);
            return;
        }
        try {
            Class<?> initializer = ctx.getClassLoader().loadClass(this.getClass().getName());
            String processMethodName = Stream.of(ClassLoaderAwareServletContainerInitializer.class.getDeclaredMethods()).filter(method -> !method.isDefault() && !method.isSynthetic()).findFirst().get().getName();
            Method operation = Stream.of(initializer.getDeclaredMethods()).filter(method -> method.getName().equals(processMethodName)).findFirst().get();
            operation.invoke(initializer.newInstance(), set, ctx);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void process(Set<Class<?>> var1, ServletContext var2) throws ServletException;
}

