/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class BuildUtil {
    private static final Properties PROPERTIES = BuildUtil.loadProperties();
    private static final String BUILD_PROPERTIES = "/build.properties";

    private BuildUtil() {
    }

    public static String getBuildProperty(String property) {
        return PROPERTIES.getProperty(property);
    }

    private static Properties loadProperties() {
        InputStream stream = BuildUtil.class.getResourceAsStream(BUILD_PROPERTIES);
        if (stream == null) {
            throw new IllegalStateException("Couldn't find /build.properties file.");
        }
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't read /build.properties file.", e);
        }
        return properties;
    }
}

