/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.server.startup.AbstractAnnotationValidator;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={Push.class})
public class WebComponentExporterAwareValidator
extends AbstractAnnotationValidator
implements ClassLoaderAwareServletContainerInitializer {
    @Override
    public void process(Set<Class<?>> classSet, ServletContext servletContext) throws ServletException {
        this.validateClasses(classSet);
    }

    @Override
    protected Optional<String> handleNonRouterLayout(Class<?> clazz) {
        if (WebComponentExporter.class.isAssignableFrom(GenericTypeReflector.erase(clazz))) {
            return Optional.empty();
        }
        return Optional.of(String.format("Class '%s' contains '%s', but it is not a router layout/top level route/web component.", clazz.getName(), this.getClassAnnotations(clazz)));
    }

    @Override
    protected String getErrorHint() {
        return "Found configuration annotations that will not be used in the application. \nMove it to a single route/a top router layout/web component of the application. \n";
    }

    @Override
    public List<Class<?>> getAnnotations() {
        return Arrays.asList(this.getClass().getAnnotation(HandlesTypes.class).value());
    }
}

