/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.VersionsJsonConverter;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class TaskRunNpmInstall
implements FallibleCommand {
    private static final String MODULES_YAML = ".modules.yaml";
    private static final String INSTALL_HASH = ".vaadin/vaadin.json";
    private final NodeUpdater packageUpdater;
    private final List<String> ignoredNodeFolders = Arrays.asList(".bin", "pnpm", ".ignored_pnpm", ".pnpm", ".staging", ".vaadin", ".modules.yaml");
    private final boolean enablePnpm;
    private final boolean requireHomeNodeExec;
    private final ClassFinder classFinder;

    TaskRunNpmInstall(ClassFinder classFinder, NodeUpdater packageUpdater, boolean enablePnpm, boolean requireHomeNodeExec) {
        this.classFinder = classFinder;
        this.packageUpdater = packageUpdater;
        this.enablePnpm = enablePnpm;
        this.requireHomeNodeExec = requireHomeNodeExec;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        String toolName;
        String string = toolName = this.enablePnpm ? "pnpm" : "npm";
        if (this.packageUpdater.modified || this.shouldRunNpmInstall()) {
            this.packageUpdater.log().info("Running `" + toolName + " install` to resolve and optionally download frontend dependencies. This may take a moment, please stand by...");
            this.runNpmInstall();
            this.updateLocalHash();
        } else {
            this.packageUpdater.log().info("Skipping `" + toolName + " install`.");
        }
    }

    private void updateLocalHash() {
        try {
            JsonObject vaadin = this.packageUpdater.getPackageJson().getObject("vaadin");
            if (vaadin == null) {
                this.packageUpdater.log().warn("No vaadin object in package.json");
                return;
            }
            String hash = vaadin.getString("hash");
            JsonObject localHash = Json.createObject();
            localHash.put("hash", hash);
            File localHashFile = this.getLocalHashFile();
            FileUtils.forceMkdirParent((File)localHashFile);
            String content = JsonUtil.stringify((JsonValue)localHash, (int)2) + "\n";
            FileUtils.writeStringToFile((File)localHashFile, (String)content, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            this.packageUpdater.log().warn("Failed to update node_modules hash.", (Throwable)e);
        }
    }

    private File getLocalHashFile() {
        return new File(this.packageUpdater.nodeModulesFolder, INSTALL_HASH);
    }

    protected String generateVersionsJson() throws IOException {
        URL resource = this.classFinder.getResource("vaadin_versions.json");
        if (resource == null) {
            this.packageUpdater.log().warn("Couldn't find {} file to pin dependency versions. Transitive dependencies won't be pinned for pnpm.", (Object)"vaadin_versions.json");
            return null;
        }
        try (InputStream content = resource.openStream();){
            File versions = new File(this.packageUpdater.generatedFolder, "versions.json");
            VersionsJsonConverter convert = new VersionsJsonConverter(Json.parse((String)IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8)), this.packageUpdater.getPackageJson());
            FileUtils.write((File)versions, (CharSequence)(JsonUtil.stringify((JsonValue)convert.getManagedVersions(), (int)2) + "\n"), (Charset)StandardCharsets.UTF_8);
            Path versionsPath = versions.toPath();
            if (versions.isAbsolute()) {
                String string = FrontendUtils.getUnixRelativePath(this.packageUpdater.npmFolder.toPath(), versionsPath);
                return string;
            }
            String string = FrontendUtils.getUnixPath(versionsPath);
            return string;
        }
    }

    private boolean shouldRunNpmInstall() {
        if (this.packageUpdater.nodeModulesFolder.isDirectory()) {
            File[] installedPackages = this.packageUpdater.nodeModulesFolder.listFiles((dir, name) -> !this.ignoredNodeFolders.contains(name));
            assert (installedPackages != null);
            return installedPackages.length == 0 || installedPackages.length == 1 && "@vaadin/flow-frontend/".startsWith(installedPackages[0].getName()) || installedPackages.length > 0 && this.isVaadinHashUpdated();
        }
        return true;
    }

    private boolean isVaadinHashUpdated() {
        File localHashFile = this.getLocalHashFile();
        if (localHashFile.exists()) {
            try {
                String fileContent = FileUtils.readFileToString((File)localHashFile, (String)StandardCharsets.UTF_8.name());
                JsonObject content = Json.parse((String)fileContent);
                if (content.hasKey("hash")) {
                    JsonObject packageJson = this.packageUpdater.getPackageJson();
                    return !content.getString("hash").equals(packageJson.getObject("vaadin").getString("hash"));
                }
            }
            catch (IOException e) {
                this.packageUpdater.log().warn("Failed to load hashes forcing npm execution", (Throwable)e);
            }
        }
        return true;
    }

    private void runNpmInstall() throws ExecutionFailedException {
        List<String> executable;
        try {
            this.cleanUp();
        }
        catch (IOException exception) {
            throw new ExecutionFailedException("Couldn't remove " + this.packageUpdater.nodeModulesFolder + " directory", exception);
        }
        if (this.enablePnpm) {
            try {
                this.createPnpmFile(this.generateVersionsJson());
            }
            catch (IOException exception) {
                throw new ExecutionFailedException("Failed to read frontend version data from vaadin-core and make it available to pnpm for locking transitive dependencies.\nPlease report an issue, as a workaround try running project with npm by setting system variable -Dvaadin.pnpm.enable=false", exception);
            }
        }
        String baseDir = this.packageUpdater.npmFolder.getAbsolutePath();
        FrontendTools tools = new FrontendTools(baseDir, () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        try {
            if (this.requireHomeNodeExec) {
                tools.forceAlternativeNodeExecutable();
            }
            executable = this.enablePnpm ? tools.getPnpmExecutable() : tools.getNpmExecutable();
        }
        catch (IllegalStateException exception) {
            throw new ExecutionFailedException(exception.getMessage(), exception);
        }
        ArrayList<String> command = new ArrayList<String>(executable);
        command.add("install");
        if (this.packageUpdater.log().isDebugEnabled()) {
            this.packageUpdater.log().debug(FrontendUtils.commandToString(this.packageUpdater.npmFolder.getAbsolutePath(), command));
        }
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("ADBLOCK", "1");
        builder.environment().put("NO_UPDATE_NOTIFIER", "1");
        builder.directory(this.packageUpdater.npmFolder);
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        String toolName = this.enablePnpm ? "pnpm" : "npm";
        Process process = null;
        try {
            Process finalProcess = process = builder.inheritIO().start();
            Runtime.getRuntime().addShutdownHook(new Thread(finalProcess::destroyForcibly));
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                this.packageUpdater.log().error(">>> Dependency ERROR. Check that all required dependencies are deployed in {} repositories.", (Object)toolName);
                throw new ExecutionFailedException(SharedUtil.capitalize(toolName) + " install has exited with non zero status. Some dependencies are not installed. Check " + toolName + " command output");
            }
            this.packageUpdater.log().info("Frontend dependencies resolved successfully.");
        }
        catch (IOException | InterruptedException e) {
            this.packageUpdater.log().error("Error when running `{} install`", (Object)toolName, (Object)e);
            throw new ExecutionFailedException("Command '" + toolName + " install' failed to finish", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    private void createPnpmFile(String versionsPath) throws IOException {
        if (versionsPath == null) {
            return;
        }
        File pnpmFile = new File(this.packageUpdater.npmFolder.getAbsolutePath(), "pnpmfile.js");
        try (InputStream content = TaskRunNpmInstall.class.getResourceAsStream("/pnpmfile.js");){
            if (content == null) {
                throw new IOException("Couldn't find template pnpmfile.js in the classpath");
            }
            FileUtils.copyInputStreamToFile((InputStream)content, (File)pnpmFile);
            this.packageUpdater.log().info("Generated pnpmfile hook file: '{}'", (Object)pnpmFile);
            FileUtils.writeLines((File)pnpmFile, this.modifyPnpmFile(pnpmFile, versionsPath));
        }
    }

    private List<String> modifyPnpmFile(File generatedFile, String versionsPath) throws IOException {
        List lines = FileUtils.readLines((File)generatedFile, (Charset)StandardCharsets.UTF_8);
        int i = 0;
        for (String line : lines) {
            if (line.startsWith("const versionsFile")) {
                lines.set(i, "const versionsFile = require('path').resolve(__dirname, '" + versionsPath + "');");
            }
            ++i;
        }
        return lines;
    }

    private void cleanUp() throws IOException {
        File staging;
        boolean hasModulesYaml;
        if (!this.packageUpdater.nodeModulesFolder.exists()) {
            return;
        }
        File modulesYaml = new File(this.packageUpdater.nodeModulesFolder, MODULES_YAML);
        boolean bl = hasModulesYaml = modulesYaml.exists() && modulesYaml.isFile();
        if (!this.enablePnpm && hasModulesYaml) {
            FileUtils.forceDelete((File)this.packageUpdater.nodeModulesFolder);
        } else if (!(!this.enablePnpm || hasModulesYaml || (staging = new File(this.packageUpdater.nodeModulesFolder, ".staging")).isDirectory() && staging.listFiles((dir, name) -> name.startsWith("pnpm-")).length != 0)) {
            FileUtils.forceDelete((File)this.packageUpdater.nodeModulesFolder);
        }
    }
}

