/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.NodeAttachChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.server.communication.MetadataWriter;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidlWriter
implements Serializable {
    private static final String COULD_NOT_READ_URL_CONTENTS_ERROR_MESSAGE = "Could not read url %s contents";

    public JsonObject createUidl(UI ui, boolean async, boolean resync) {
        List<PendingJavaScriptInvocation> executeJavaScriptList;
        JsonObject response = Json.createObject();
        UIInternals uiInternals = ui.getInternals();
        VaadinSession session = ui.getSession();
        VaadinService service = session.getService();
        service.runPendingAccessTasks(session);
        UidlWriter.getLogger().debug("* Creating response to client");
        int syncId = service.getDeploymentConfiguration().isSyncIdCheckEnabled() ? uiInternals.getServerSyncId() : -1;
        response.put("syncId", (double)syncId);
        if (resync) {
            response.put("resynchronize", true);
        }
        int nextClientToServerMessageId = uiInternals.getLastProcessedClientToServerId() + 1;
        response.put("clientId", (double)nextClientToServerMessageId);
        SystemMessages messages = ui.getSession().getService().getSystemMessages(ui.getLocale(), null);
        JsonObject meta = new MetadataWriter().createMetadata(ui, false, async, messages);
        if (meta.keys().length > 0) {
            response.put("meta", (JsonValue)meta);
        }
        JsonArray stateChanges = Json.createArray();
        this.encodeChanges(ui, stateChanges);
        UidlWriter.populateDependencies(response, uiInternals.getDependencyList(), new ResolveContext(service, session.getBrowser()));
        if (uiInternals.getConstantPool().hasNewConstants()) {
            response.put("constants", (JsonValue)uiInternals.getConstantPool().dumpConstants());
        }
        if (stateChanges.length() != 0) {
            response.put("changes", (JsonValue)stateChanges);
        }
        if (!(executeJavaScriptList = uiInternals.dumpPendingJavaScriptInvocations()).isEmpty()) {
            response.put("execute", (JsonValue)UidlWriter.encodeExecuteJavaScriptList(executeJavaScriptList));
        }
        if (ui.getSession().getService().getDeploymentConfiguration().isRequestTiming()) {
            response.put("timings", this.createPerformanceData(ui));
        }
        uiInternals.incrementServerId();
        return response;
    }

    public JsonObject createUidl(UI ui, boolean async) {
        return this.createUidl(ui, async, false);
    }

    private static void populateDependencies(JsonObject response, DependencyList dependencyList, ResolveContext context) {
        Collection<Dependency> pendingSendToClient = dependencyList.getPendingSendToClient();
        for (DependencyFilter filter : context.getService().getDependencyFilters()) {
            pendingSendToClient = filter.filter(new ArrayList<Dependency>(pendingSendToClient), context.getService());
        }
        if (!pendingSendToClient.isEmpty()) {
            UidlWriter.groupDependenciesByLoadMode(pendingSendToClient, context).forEach((loadMode, dependencies) -> response.put(loadMode.name(), (JsonValue)dependencies));
        }
        dependencyList.clearPendingSendToClient();
    }

    private static Map<LoadMode, JsonArray> groupDependenciesByLoadMode(Collection<Dependency> dependencies, ResolveContext context) {
        EnumMap<LoadMode, JsonArray> result = new EnumMap<LoadMode, JsonArray>(LoadMode.class);
        dependencies.forEach(dependency -> result.merge(dependency.getLoadMode(), JsonUtils.createArray(new JsonValue[]{UidlWriter.dependencyToJson(dependency, context)}), JsonUtils.asArray().combiner()));
        return result;
    }

    private static JsonObject dependencyToJson(Dependency dependency, ResolveContext context) {
        JsonObject dependencyJson = dependency.toJson();
        if (dependency.getLoadMode() == LoadMode.INLINE) {
            dependencyJson.put("contents", UidlWriter.getDependencyContents(dependency.getUrl(), context));
            dependencyJson.remove("url");
        }
        return dependencyJson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDependencyContents(String url, ResolveContext context) {
        try (InputStream inlineResourceStream = UidlWriter.getInlineResourceStream(url, context);){
            String string = IOUtils.toString((InputStream)inlineResourceStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(COULD_NOT_READ_URL_CONTENTS_ERROR_MESSAGE, url), e);
        }
    }

    private static InputStream getInlineResourceStream(String url, ResolveContext context) {
        VaadinService service = context.getService();
        InputStream stream = service.getResourceAsStream(url);
        if (stream == null) {
            String resolvedPath = service.resolveResource(url);
            UidlWriter.getLogger().warn("The path '{}' for inline resource has been resolved to '{}'. But resource is not available via the servlet context. Trying to load '{}' as a URL", new Object[]{url, resolvedPath, url});
            try {
                stream = new URL(url).openConnection().getInputStream();
            }
            catch (MalformedURLException exception) {
                throw new IllegalStateException(String.format("The path '%s' is not a valid URL. Unable to fetch a resource addressed by it.", url), exception);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format(COULD_NOT_READ_URL_CONTENTS_ERROR_MESSAGE, url), e);
            }
        } else if (UidlWriter.getLogger().isDebugEnabled()) {
            String resolvedPath = service.resolveResource(url);
            UidlWriter.getLogger().debug("The path '{}' for inline resource has been successfully resolved to resource URL '{}'", (Object)url, (Object)resolvedPath);
        }
        return stream;
    }

    static JsonArray encodeExecuteJavaScriptList(List<PendingJavaScriptInvocation> executeJavaScriptList) {
        return executeJavaScriptList.stream().map(UidlWriter::encodeExecuteJavaScript).collect(JsonUtils.asArray());
    }

    private static ReturnChannelRegistration createReturnValueChannel(StateNode owner, List<ReturnChannelRegistration> registrations, SerializableConsumer<JsonValue> action) {
        ReturnChannelRegistration channel = owner.getFeature(ReturnChannelMap.class).registerChannel(arguments -> {
            registrations.forEach(Registration::remove);
            action.accept(arguments.get(0));
        });
        registrations.add(channel);
        return channel;
    }

    private static JsonArray encodeExecuteJavaScript(PendingJavaScriptInvocation invocation) {
        List<Object> parametersList = invocation.getInvocation().getParameters();
        Stream<Object> parameters = parametersList.stream();
        String expression = invocation.getInvocation().getExpression();
        if (invocation.isSubscribed()) {
            StateNode owner = invocation.getOwner();
            ArrayList<ReturnChannelRegistration> channels = new ArrayList<ReturnChannelRegistration>();
            ReturnChannelRegistration successChannel = UidlWriter.createReturnValueChannel(owner, channels, invocation::complete);
            ReturnChannelRegistration errorChannel = UidlWriter.createReturnValueChannel(owner, channels, invocation::completeExceptionally);
            parameters = Stream.concat(parameters, Stream.of(successChannel, errorChannel));
            int successIndex = parametersList.size();
            int errorIndex = successIndex + 1;
            expression = "try{Promise.resolve((function(){" + expression + "})()).then($" + successIndex + ",function(error){$" + errorIndex + "(''+error)})}catch(error){$" + errorIndex + "(''+error)}";
        }
        return Stream.concat(parameters.map(JsonCodec::encodeWithTypeInfo), Stream.of(Json.create((String)expression))).collect(JsonUtils.asArray());
    }

    private void encodeChanges(UI ui, JsonArray stateChanges) {
        UIInternals uiInternals = ui.getInternals();
        StateTree stateTree = uiInternals.getStateTree();
        stateTree.runExecutionsBeforeClientResponse();
        LinkedHashSet componentsWithDependencies = new LinkedHashSet();
        stateTree.collectChanges(change -> {
            if (UidlWriter.attachesComponent(change)) {
                ComponentMapping.getComponent(change.getNode()).ifPresent(component -> this.addComponentHierarchy(ui, componentsWithDependencies, (Component)component));
            }
            stateChanges.set(stateChanges.length(), (JsonValue)change.toJson(uiInternals.getConstantPool()));
        });
        componentsWithDependencies.forEach(uiInternals::addComponentDependencies);
    }

    private static boolean attachesComponent(NodeChange change) {
        return change instanceof NodeAttachChange && change.getNode().hasFeature(ComponentMapping.class);
    }

    private void addComponentHierarchy(UI ui, Set<Class<? extends Component>> hierarchyStorage, Component component) {
        hierarchyStorage.add(component.getClass());
        if (component instanceof Composite) {
            this.addComponentHierarchy(ui, hierarchyStorage, (Component)((Composite)component).getContent());
        }
    }

    private JsonValue createPerformanceData(UI ui) {
        JsonArray timings = Json.createArray();
        timings.set(0, (double)ui.getSession().getCumulativeRequestDuration());
        timings.set(1, (double)ui.getSession().getLastRequestDuration());
        return timings;
    }

    private static final Logger getLogger() {
        return LoggerFactory.getLogger((String)UidlWriter.class.getName());
    }

    public static class ResolveContext
    implements Serializable {
        private VaadinService service;
        private WebBrowser browser;

        public ResolveContext(VaadinService service, WebBrowser browser) {
            this.service = Objects.requireNonNull(service);
            this.browser = Objects.requireNonNull(browser);
        }

        public VaadinService getService() {
            return this.service;
        }

        public WebBrowser getBrowser() {
            return this.browser;
        }
    }
}

