/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdateWebpack
implements FallibleCommand {
    private final String webpackTemplate;
    private final String webpackGeneratedTemplate;
    private final Path webpackOutputPath;
    private final Path flowImportsFilePath;
    private final Path webpackConfigPath;
    private final Path frontendDirectory;
    private final boolean useV14Bootstrapping;

    TaskUpdateWebpack(File frontendDirectory, File webpackConfigFolder, File webpackOutputDirectory, String webpackTemplate, String webpackGeneratedTemplate, File generatedFlowImports, boolean useV14Bootstrapping) {
        this.frontendDirectory = frontendDirectory.toPath();
        this.webpackTemplate = webpackTemplate;
        this.webpackGeneratedTemplate = webpackGeneratedTemplate;
        this.webpackOutputPath = webpackOutputDirectory.toPath();
        this.flowImportsFilePath = generatedFlowImports.toPath();
        this.webpackConfigPath = webpackConfigFolder.toPath();
        this.useV14Bootstrapping = useV14Bootstrapping;
    }

    @Override
    public void execute() {
        try {
            this.createWebpackConfig();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createWebpackConfig() throws IOException {
        if (this.webpackTemplate == null || this.webpackTemplate.trim().isEmpty()) {
            return;
        }
        File configFile = new File(this.webpackConfigPath.toFile(), "webpack.config.js");
        if (configFile.exists()) {
            if (!FrontendUtils.isWebpackConfigFile(configFile)) {
                this.log().warn("Flow generated webpack configuration was not mentioned in the configuration file: {}.Please verify that './webpack.generated.js' is used in the merge or remove the file to generate a new one.", (Object)configFile);
            }
        } else {
            URL resource = this.getClass().getClassLoader().getResource(this.webpackTemplate);
            FileUtils.copyURLToFile((URL)resource, (File)configFile);
            this.log().info("Created webpack configuration file: '{}'", (Object)configFile);
        }
        File generatedFile = new File(this.webpackConfigPath.toFile(), "webpack.generated.js");
        URL resource = this.getClass().getClassLoader().getResource(this.webpackGeneratedTemplate);
        FileUtils.copyURLToFile((URL)resource, (File)generatedFile);
        List<String> lines = this.modifyWebpackConfig(generatedFile);
        FileUtils.writeLines((File)generatedFile, lines);
    }

    private List<String> modifyWebpackConfig(File generatedFile) throws IOException {
        List lines = FileUtils.readLines((File)generatedFile, (String)"UTF-8");
        String frontendLine = "const frontendFolder = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.frontendDirectory) + "');";
        String outputLine = "const mavenOutputFolderForFlowBundledFiles = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.webpackOutputPath) + "');";
        String mainLine = "const fileNameOfTheFlowGeneratedMainEntryPoint = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.flowImportsFilePath) + "');";
        String isClientSideBootstrapModeLine = "const useClientSideIndexFileForBootstrapping = " + !this.useV14Bootstrapping + ";";
        for (int i = 0; i < lines.size(); ++i) {
            if (((String)lines.get(i)).startsWith("const fileNameOfTheFlowGeneratedMainEntryPoint")) {
                lines.set(i, mainLine);
            }
            if (((String)lines.get(i)).startsWith("const mavenOutputFolderForFlowBundledFiles")) {
                lines.set(i, outputLine);
            }
            if (((String)lines.get(i)).startsWith("const frontendFolder")) {
                lines.set(i, frontendLine);
            }
            if (((String)lines.get(i)).startsWith("const useClientSideIndexFileForBootstrapping")) {
                lines.set(i, isClientSideBootstrapModeLine);
            }
            if (((String)lines.get(i)).startsWith("const clientSideIndexHTML")) {
                lines.set(i, this.getIndexHtmlPath());
            }
            if (!((String)lines.get(i)).startsWith("const clientSideIndexEntryPoint")) continue;
            lines.set(i, this.getClientEntryPoint());
        }
        return lines;
    }

    private String getIndexHtmlPath() {
        boolean exists = new File(this.frontendDirectory.toFile(), "index.html").exists();
        String declaration = "const clientSideIndexHTML = %s;";
        if (!exists) {
            Path path = Paths.get(this.getEscapedRelativeWebpackPath(this.webpackConfigPath), "target/", "index.html");
            String relativePath = String.format("require('path').resolve(__dirname, '%s')", this.getEscapedRelativeWebpackPath(path));
            return String.format(declaration, relativePath);
        }
        return String.format(declaration, "'./index.html'");
    }

    private String getClientEntryPoint() {
        boolean exists = new File(this.frontendDirectory.toFile(), "index.ts").exists() || new File(this.frontendDirectory.toFile(), "index.js").exists();
        String declaration = "const clientSideIndexEntryPoint = %s;";
        if (!exists) {
            Path path = Paths.get(this.getEscapedRelativeWebpackPath(this.webpackConfigPath), "target/", "index.ts");
            String relativePath = String.format("require('path').resolve(__dirname, '%s')", this.getEscapedRelativeWebpackPath(path).replaceFirst("\\.[tj]s$", ""));
            return String.format(declaration, relativePath);
        }
        return String.format(declaration, "'./index'");
    }

    private String getEscapedRelativeWebpackPath(Path path) {
        if (path.isAbsolute()) {
            return FrontendUtils.getUnixRelativePath(this.webpackConfigPath, path);
        }
        return FrontendUtils.getUnixPath(path);
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

