/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.CompressUtil;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.TaskRunDevBundleBuild;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevBundleUtils {
    private DevBundleUtils() {
    }

    public static URL findBundleFile(File projectDir, String buildFolder, String filename) throws IOException {
        File bundleFile;
        File devBundleFolder = DevBundleUtils.getDevBundleFolder(projectDir, buildFolder);
        if (devBundleFolder.exists() && (bundleFile = new File(devBundleFolder, filename)).exists()) {
            return bundleFile.toURI().toURL();
        }
        return TaskRunDevBundleBuild.class.getClassLoader().getResource("vaadin-dev-bundle/" + filename);
    }

    public static File getDevBundleFolder(File projectDir, String buildFolder) {
        return new File(new File(projectDir, buildFolder), "dev-bundle");
    }

    public static String findBundleStatsJson(File projectDir, String buildFolder) throws IOException {
        URL statsJson = DevBundleUtils.findBundleFile(projectDir, buildFolder, "config/stats.json");
        if (statsJson == null) {
            DevBundleUtils.getLogger().warn("There is no dev-bundle in the project or on the classpath nor is there a default bundle included.");
            return null;
        }
        return FileIOUtils.urlToString(statsJson);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevBundleUtils.class);
    }

    public static void compressBundle(File projectDir, File devBundleFolder) {
        File bundleFile = new File(projectDir, "src/main/bundles/dev.bundle");
        if (bundleFile.exists()) {
            bundleFile.delete();
        } else {
            bundleFile.getParentFile().mkdirs();
        }
        CompressUtil.compressDirectory(devBundleFolder, bundleFile);
    }

    public static void unpackBundle(File projectDir, File devBundleFolder) {
        File bundleFile = new File(projectDir, "src/main/bundles/dev.bundle");
        CompressUtil.uncompressFile(bundleFile, devBundleFolder);
    }
}

