/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class ProxyFactory {
    static final String NPMRC_NOPROXY_PROPERTY_KEY = "noproxy";
    static final String NPMRC_HTTPS_PROXY_PROPERTY_KEY = "https-proxy";
    static final String NPMRC_PROXY_PROPERTY_KEY = "proxy";
    static final String SYSTEM_NOPROXY_PROPERTY_KEY = "NOPROXY";
    static final String SYSTEM_HTTPS_PROXY_PROPERTY_KEY = "HTTPS_PROXY";
    static final String SYSTEM_HTTP_PROXY_PROPERTY_KEY = "HTTP_PROXY";

    public static List<ProxyConfig.Proxy> getProxies(File projectDirectory) {
        File projectNpmrc = new File(projectDirectory, ".npmrc");
        File userNpmrc = new File(FileIOUtils.getUserDirectory(), ".npmrc");
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>();
        proxyList.addAll(ProxyFactory.readProxySettingsFromSystemProperties());
        proxyList.addAll(ProxyFactory.readProxySettingsFromNpmrcFile("user .npmrc", userNpmrc));
        proxyList.addAll(ProxyFactory.readProxySettingsFromNpmrcFile("project .npmrc", projectNpmrc));
        proxyList.addAll(ProxyFactory.readProxySettingsFromEnvironmentVariables());
        return proxyList;
    }

    private static List<ProxyConfig.Proxy> readProxySettingsFromNpmrcFile(String fileDescription, File npmrc) {
        ArrayList<ProxyConfig.Proxy> arrayList;
        if (!npmrc.exists()) {
            return Collections.emptyList();
        }
        FileReader fileReader = new FileReader(npmrc);
        try {
            String proxyUrl;
            String httpsProxyUrl;
            ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
            Properties properties = new Properties();
            properties.load(fileReader);
            String noproxy = properties.getProperty(NPMRC_NOPROXY_PROPERTY_KEY);
            if (noproxy != null) {
                noproxy = noproxy.replaceAll(",", "|");
            }
            if ((httpsProxyUrl = properties.getProperty(NPMRC_HTTPS_PROXY_PROPERTY_KEY)) != null) {
                proxyList.add(new ProxyConfig.Proxy("https-proxy - " + fileDescription, httpsProxyUrl, noproxy));
            }
            if ((proxyUrl = properties.getProperty(NPMRC_PROXY_PROPERTY_KEY)) != null) {
                proxyList.add(new ProxyConfig.Proxy("proxy - " + fileDescription, proxyUrl, noproxy));
            }
            arrayList = proxyList;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        fileReader.close();
        return arrayList;
    }

    private static List<ProxyConfig.Proxy> readProxySettingsFromSystemProperties() {
        String proxyUrl;
        String httpsProxyUrl;
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
        String noproxy = ProxyFactory.getNonNull(System.getProperty(SYSTEM_NOPROXY_PROPERTY_KEY), System.getProperty(SYSTEM_NOPROXY_PROPERTY_KEY.toLowerCase()));
        if (noproxy != null) {
            noproxy = noproxy.replaceAll(",", "|");
        }
        if ((httpsProxyUrl = ProxyFactory.getNonNull(System.getProperty(SYSTEM_HTTPS_PROXY_PROPERTY_KEY), System.getProperty(SYSTEM_HTTPS_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("https-proxy - system", httpsProxyUrl, noproxy));
        }
        if ((proxyUrl = ProxyFactory.getNonNull(System.getProperty(SYSTEM_HTTP_PROXY_PROPERTY_KEY), System.getProperty(SYSTEM_HTTP_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("proxy - system", proxyUrl, noproxy));
        }
        return proxyList;
    }

    private static List<ProxyConfig.Proxy> readProxySettingsFromEnvironmentVariables() {
        String proxyUrl;
        String httpsProxyUrl;
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
        String noproxy = ProxyFactory.getNonNull(System.getenv(SYSTEM_NOPROXY_PROPERTY_KEY), System.getenv(SYSTEM_NOPROXY_PROPERTY_KEY.toLowerCase()));
        if (noproxy != null) {
            noproxy = noproxy.replaceAll(",", "|");
        }
        if ((httpsProxyUrl = ProxyFactory.getNonNull(System.getenv(SYSTEM_HTTPS_PROXY_PROPERTY_KEY), System.getenv(SYSTEM_HTTPS_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("https-proxy - env", httpsProxyUrl, noproxy));
        }
        if ((proxyUrl = ProxyFactory.getNonNull(System.getenv(SYSTEM_HTTP_PROXY_PROPERTY_KEY), System.getenv(SYSTEM_HTTP_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("proxy - env", proxyUrl, noproxy));
        }
        return proxyList;
    }

    private static String getNonNull(String ... valueArray) {
        for (String value : valueArray) {
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

