/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.FrontendPluginsUtil;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class TaskInstallFrontendBuildPlugins
implements FallibleCommand {
    private final File targetFolder;

    public TaskInstallFrontendBuildPlugins(Options options) {
        this.targetFolder = new File(options.getBuildDirectory(), "plugins");
    }

    @Override
    public void execute() {
        FrontendPluginsUtil.getPlugins().forEach(plugin -> {
            try {
                this.generatePluginFiles((String)plugin);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Installation of Flow frontend plugin '" + plugin + "' failed", ioe);
            }
        });
    }

    private void generatePluginFiles(String pluginName) throws IOException {
        String packageFile;
        ObjectNode targetJson;
        File pluginTargetFolder = new File(this.targetFolder, pluginName);
        String pluginFolderName = "plugins/" + pluginName + "/";
        JsonNode packageJson = FrontendPluginsUtil.getJsonFile(pluginFolderName + "package.json");
        if (packageJson == null) {
            this.log().error("Couldn't locate '{}' for plugin '{}'. Plugin will not be installed.", (Object)"package.json", (Object)pluginName);
            return;
        }
        if (pluginTargetFolder.exists() && new File(pluginTargetFolder, "package.json").exists() && (targetJson = JacksonUtils.readTree(packageFile = FileUtils.readFileToString((File)new File(pluginTargetFolder, "package.json"), (Charset)StandardCharsets.UTF_8))).has("update") && !targetJson.get("update").booleanValue()) {
            return;
        }
        FileUtils.forceMkdir((File)pluginTargetFolder);
        JsonNode files = packageJson.get("files");
        for (int i = 0; i < files.size(); ++i) {
            String file = files.get(i).textValue();
            this.copyIfNeeded(new File(pluginTargetFolder, file), pluginFolderName + file);
        }
        this.copyIfNeeded(new File(pluginTargetFolder, "package.json"), pluginFolderName + "package.json");
    }

    private void copyIfNeeded(File targetFile, String sourceResource) throws IOException {
        String content = IOUtils.toString((URL)FrontendPluginsUtil.getResourceUrl(sourceResource), (Charset)StandardCharsets.UTF_8);
        FileIOUtils.writeIfChanged(targetFile, content);
    }

    private Logger log() {
        return LoggerFactory.getLogger(TaskInstallFrontendBuildPlugins.class);
    }
}

