/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.BundleUtils;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.frontend.EndpointGeneratorTaskFactory;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendWebComponentGenerator;
import com.vaadin.flow.server.frontend.GeneratedFilesSupport;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.ProdBundleUtils;
import com.vaadin.flow.server.frontend.TaskCleanFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyNpmAssetsFiles;
import com.vaadin.flow.server.frontend.TaskCopyTemplateFiles;
import com.vaadin.flow.server.frontend.TaskGenerateBootstrap;
import com.vaadin.flow.server.frontend.TaskGenerateCommercialBanner;
import com.vaadin.flow.server.frontend.TaskGenerateEndpoint;
import com.vaadin.flow.server.frontend.TaskGenerateFeatureFlags;
import com.vaadin.flow.server.frontend.TaskGenerateIndexHtml;
import com.vaadin.flow.server.frontend.TaskGenerateIndexTs;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import com.vaadin.flow.server.frontend.TaskGeneratePWAIcons;
import com.vaadin.flow.server.frontend.TaskGeneratePackageJson;
import com.vaadin.flow.server.frontend.TaskGenerateReactFiles;
import com.vaadin.flow.server.frontend.TaskGenerateServiceWorker;
import com.vaadin.flow.server.frontend.TaskGenerateTsConfig;
import com.vaadin.flow.server.frontend.TaskGenerateTsDefinitions;
import com.vaadin.flow.server.frontend.TaskGenerateViteDevMode;
import com.vaadin.flow.server.frontend.TaskGenerateWebComponentBootstrap;
import com.vaadin.flow.server.frontend.TaskGenerateWebComponentHtml;
import com.vaadin.flow.server.frontend.TaskInstallFrontendBuildPlugins;
import com.vaadin.flow.server.frontend.TaskPrepareProdBundle;
import com.vaadin.flow.server.frontend.TaskRemoveOldFrontendGeneratedFiles;
import com.vaadin.flow.server.frontend.TaskRunDevBundleBuild;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.TaskUpdateImports;
import com.vaadin.flow.server.frontend.TaskUpdateOldIndexTs;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.TaskUpdateSettingsFile;
import com.vaadin.flow.server.frontend.TaskUpdateThemeImport;
import com.vaadin.flow.server.frontend.TaskUpdateVite;
import com.vaadin.flow.server.frontend.UnknownTaskException;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTasks
implements FallibleCommand {
    private static final List<Class<? extends FallibleCommand>> commandOrder = Collections.unmodifiableList(Arrays.asList(TaskGeneratePackageJson.class, TaskGenerateIndexHtml.class, TaskGenerateIndexTs.class, TaskGenerateReactFiles.class, TaskUpdateOldIndexTs.class, TaskGenerateViteDevMode.class, TaskGenerateCommercialBanner.class, TaskGenerateTsConfig.class, TaskGenerateTsDefinitions.class, TaskGenerateServiceWorker.class, TaskGenerateWebComponentHtml.class, TaskGenerateWebComponentBootstrap.class, TaskGenerateFeatureFlags.class, TaskInstallFrontendBuildPlugins.class, TaskUpdatePackages.class, TaskRunNpmInstall.class, TaskGenerateOpenAPI.class, TaskGenerateEndpoint.class, TaskCopyFrontendFiles.class, TaskCopyLocalFrontendFiles.class, TaskCopyNpmAssetsFiles.class, TaskGeneratePWAIcons.class, TaskUpdateSettingsFile.class, TaskUpdateVite.class, TaskUpdateImports.class, TaskUpdateThemeImport.class, TaskCopyTemplateFiles.class, TaskGenerateBootstrap.class, TaskRunDevBundleBuild.class, TaskPrepareProdBundle.class, TaskCleanFrontendFiles.class, TaskRemoveOldFrontendGeneratedFiles.class));
    private final List<FallibleCommand> commands = new ArrayList<FallibleCommand>();
    private Path lockFile;

    public NodeTasks(Options options) {
        PwaConfiguration pwa;
        FrontendDependenciesScanner frontendDependencies = options.getFrontendDependenciesScanner();
        this.lockFile = new File(options.getNpmFolder(), ".vaadin-node-tasks.lock").toPath();
        ClassFinder classFinder = options.getClassFinder();
        HashSet<String> webComponentTags = new HashSet();
        if (options.isFrontendHotdeploy()) {
            UsageStatistics.markAsUsed("flow/hotdeploy", null);
        }
        if (options.isEnablePackagesUpdate() || options.isEnableImportsUpdate() || options.isEnableConfigUpdate()) {
            FrontendWebComponentGenerator generator;
            Set<File> webComponents;
            if (options.isProductionMode()) {
                boolean needBuild = BundleValidationUtil.needsBuild(options, frontendDependencies, Mode.PRODUCTION_PRECOMPILED_BUNDLE);
                options.withRunNpmInstall(needBuild);
                options.withBundleBuild(needBuild);
                if (!needBuild) {
                    this.commands.add(new TaskPrepareProdBundle(options));
                    File prodBundle = ProdBundleUtils.getProdBundle(options.getNpmFolder());
                    if (prodBundle.exists()) {
                        UsageStatistics.markAsUsed("flow/app-prod-bundle", null);
                    } else {
                        UsageStatistics.markAsUsed("flow/prod-pre-compiled-bundle", null);
                    }
                } else {
                    this.commands.add(new TaskGenerateCommercialBanner(options));
                    BundleUtils.copyPackageLockFromBundle(options);
                }
            } else if (options.isBundleBuild()) {
                if (BundleValidationUtil.needsBuild(options, frontendDependencies, Mode.DEVELOPMENT_BUNDLE)) {
                    this.commands.add(new TaskCleanFrontendFiles(options));
                    options.withRunNpmInstall(true);
                    options.withCopyTemplates(true);
                    BundleUtils.copyPackageLockFromBundle(options);
                    UsageStatistics.markAsUsed("flow/app-dev-bundle", null);
                } else {
                    options.withBundleBuild(false);
                    File devBundleFolder = DevBundleUtils.getDevBundleFolder(options.getNpmFolder(), options.getBuildDirectoryName());
                    if (devBundleFolder.exists()) {
                        UsageStatistics.markAsUsed("flow/app-dev-bundle", null);
                    } else {
                        UsageStatistics.markAsUsed("flow/dev-bundle", null);
                    }
                }
            } else if (options.isFrontendHotdeploy()) {
                BundleUtils.copyPackageLockFromBundle(options);
            }
            if (options.isGenerateEmbeddableWebComponents() && (webComponents = (generator = new FrontendWebComponentGenerator(classFinder)).generateWebComponents(FrontendUtils.getFlowGeneratedWebComponentsFolder(options.getFrontendDirectory()), frontendDependencies.getThemeDefinition())).size() > 0) {
                this.commands.add(new TaskGenerateWebComponentHtml(options));
                this.commands.add(new TaskGenerateWebComponentBootstrap(options));
                webComponentTags = webComponents.stream().map(webComponentPath -> FilenameUtils.removeExtension((String)webComponentPath.getName())).collect(Collectors.toSet());
                UsageStatistics.markAsUsed("has-exported-wc", null);
            }
            TaskUpdatePackages packageUpdater = null;
            if (options.isEnablePackagesUpdate() && options.getJarFrontendResourcesFolder() != null) {
                packageUpdater = new TaskUpdatePackages(frontendDependencies, options);
                this.commands.add(packageUpdater);
            }
            if (packageUpdater != null && options.isRunNpmInstall()) {
                this.commands.add(new TaskRunNpmInstall(packageUpdater, options));
                this.commands.add(new TaskInstallFrontendBuildPlugins(options));
            }
            if (packageUpdater != null && options.isDevBundleBuild()) {
                this.commands.add(new TaskRunDevBundleBuild(options));
            }
        }
        if (options.isCreateMissingPackageJson()) {
            TaskGeneratePackageJson packageCreator = new TaskGeneratePackageJson(options);
            this.commands.add(packageCreator);
        }
        if (frontendDependencies != null) {
            this.addGenerateServiceWorkerTask(options, frontendDependencies.getPwaConfiguration());
            if (options.isFrontendHotdeploy() || options.isBundleBuild()) {
                this.addGenerateTsConfigTask(options);
            }
        }
        this.addBootstrapTasks(options);
        this.addEndpointServicesTasks(options);
        this.commands.add(new TaskGenerateBootstrap(frontendDependencies, options));
        this.commands.add(new TaskGenerateFeatureFlags(options));
        if (options.getJarFiles() != null && options.getJarFrontendResourcesFolder() != null) {
            this.commands.add(new TaskCopyFrontendFiles(options));
        }
        if (options.getLocalResourcesFolder() != null && options.getJarFrontendResourcesFolder() != null) {
            this.commands.add(new TaskCopyLocalFrontendFiles(options));
        }
        if (this.commands.stream().noneMatch(TaskRunDevBundleBuild.class::isInstance)) {
            this.commands.add(new TaskCopyNpmAssetsFiles(options));
        }
        String themeName = "";
        if (frontendDependencies != null) {
            if (frontendDependencies.getThemeDefinition() != null) {
                themeName = frontendDependencies.getThemeDefinition().getName();
            }
            pwa = frontendDependencies.getPwaConfiguration();
        } else {
            pwa = new PwaConfiguration();
        }
        if (options.isProductionMode() && pwa.isEnabled()) {
            this.commands.add(new TaskGeneratePWAIcons(options, pwa));
        }
        this.commands.add(new TaskUpdateSettingsFile(options, themeName, pwa));
        if (options.isFrontendHotdeploy() || options.isBundleBuild()) {
            this.commands.add(new TaskUpdateVite(options, webComponentTags));
        }
        if (options.isEnableImportsUpdate()) {
            this.commands.add(new TaskUpdateImports(frontendDependencies, options));
            this.commands.add(new TaskUpdateThemeImport(frontendDependencies.getThemeDefinition(), options));
        }
        if (options.isCopyTemplates()) {
            this.commands.add(new TaskCopyTemplateFiles(classFinder, options));
        }
        if (options.isCleanOldGeneratedFiles()) {
            this.commands.add(new TaskRemoveOldFrontendGeneratedFiles(options));
        }
    }

    private void addBootstrapTasks(Options options) {
        this.commands.add(new TaskGenerateIndexHtml(options));
        if (options.isProductionMode() || options.isFrontendHotdeploy() || options.isBundleBuild()) {
            this.commands.add(new TaskGenerateIndexTs(options));
            this.commands.add(new TaskGenerateReactFiles(options));
            if (!options.isProductionMode()) {
                this.commands.add(new TaskGenerateViteDevMode(options));
            }
        }
        this.commands.add(new TaskUpdateOldIndexTs(options));
    }

    private void addGenerateTsConfigTask(Options options) {
        TaskGenerateTsConfig taskGenerateTsConfig = new TaskGenerateTsConfig(options);
        this.commands.add(taskGenerateTsConfig);
        TaskGenerateTsDefinitions taskGenerateTsDefinitions = new TaskGenerateTsDefinitions(options);
        this.commands.add(taskGenerateTsDefinitions);
    }

    private void addGenerateServiceWorkerTask(Options options, PwaConfiguration pwaConfiguration) {
        if (pwaConfiguration.isEnabled()) {
            this.commands.add(new TaskGenerateServiceWorker(options));
        }
    }

    private void addEndpointServicesTasks(Options options) {
        if (!FrontendUtils.isHillaUsed(options.getFrontendDirectory(), options.getClassFinder())) {
            return;
        }
        Lookup lookup = options.getLookup();
        EndpointGeneratorTaskFactory endpointGeneratorTaskFactory = lookup.lookup(EndpointGeneratorTaskFactory.class);
        if (endpointGeneratorTaskFactory != null) {
            TaskGenerateOpenAPI taskGenerateOpenAPI = endpointGeneratorTaskFactory.createTaskGenerateOpenAPI(options);
            this.commands.add(taskGenerateOpenAPI);
            if (options.getFrontendGeneratedFolder() != null) {
                TaskGenerateEndpoint taskGenerateEndpoint = endpointGeneratorTaskFactory.createTaskGenerateEndpoint(options);
                this.commands.add(taskGenerateEndpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ExecutionFailedException {
        this.getLock();
        try {
            this.sortCommands(this.commands);
            GeneratedFilesSupport generatedFilesSupport = new GeneratedFilesSupport();
            for (FallibleCommand command : this.commands) {
                long startTime = System.nanoTime();
                command.setGeneratedFileSupport(generatedFilesSupport);
                command.execute();
                Duration durationInNs = Duration.ofNanos(System.nanoTime() - startTime);
                this.getLogger().debug("Task [ {} ] completed in {} ms", (Object)command.getClass().getSimpleName(), (Object)durationInNs.toMillis());
            }
        }
        finally {
            this.releaseLock();
        }
    }

    private void getLock() {
        boolean loggedWaiting = false;
        while (this.lockFile.toFile().exists()) {
            NodeTasksLockInfo lockInfo;
            try {
                lockInfo = this.readLockFile();
            }
            catch (Exception e) {
                this.getLogger().error("Error waiting for another " + this.getClass().getSimpleName() + " process to finish", (Throwable)e);
                break;
            }
            try {
                Optional<ProcessHandle> processHandle = ProcessHandle.of(lockInfo.pid());
                if (processHandle.isPresent() && this.normalizeCommandLine(processHandle.get().info()).equals(lockInfo.commandLine())) {
                    if (!loggedWaiting) {
                        this.getLogger().info("Waiting for a previous instance of " + this.getClass().getSimpleName() + " (pid: " + lockInfo.pid() + ") to finish...");
                        loggedWaiting = true;
                    }
                    Thread.sleep(500L);
                    continue;
                }
                this.lockFile.toFile().delete();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for another " + this.getClass().getSimpleName() + " process (pid: " + lockInfo.pid() + ") to finish", e);
            }
            catch (Exception e) {
                this.getLogger().error("Error waiting for another " + this.getClass().getSimpleName() + " process (pid: " + lockInfo.pid() + ") to finish", (Throwable)e);
            }
        }
        try {
            this.writeLockFile();
        }
        catch (IOException e) {
            this.getLogger().error("Error writing lock file ({})", (Object)this.lockFile.toFile().getAbsolutePath(), (Object)e);
        }
    }

    private void releaseLock() {
        if (!this.lockFile.toFile().exists()) {
            this.getLogger().warn("Somebody else has removed the lock file ({})", (Object)this.lockFile.toFile().getAbsolutePath());
            return;
        }
        try {
            long pid = this.readLockFile().pid();
            if (pid != ProcessHandle.current().pid()) {
                this.getLogger().warn("Another process ({}) has overwritten the lock file ({})", (Object)pid, (Object)this.lockFile.toFile().getAbsolutePath());
                return;
            }
            this.lockFile.toFile().delete();
        }
        catch (Exception e) {
            this.getLogger().error("Error releasing lock file ({})", (Object)this.lockFile.toFile().getAbsolutePath());
        }
    }

    private NodeTasksLockInfo readLockFile() throws NumberFormatException, IOException {
        List<String> lines = Files.readAllLines(this.lockFile, StandardCharsets.UTF_8);
        if (lines.size() != 2) {
            throw new IllegalStateException("Invalid lock file. It should contain 2 rows but contains " + String.valueOf(lines));
        }
        return new NodeTasksLockInfo(Long.parseLong(lines.get(0)), lines.get(1));
    }

    private void writeLockFile() throws IOException {
        ProcessHandle currentProcess = ProcessHandle.current();
        long myPid = currentProcess.pid();
        String commandLine = this.normalizeCommandLine(currentProcess.info());
        List<String> lines = List.of(Long.toString(myPid), commandLine);
        Files.write(this.lockFile, lines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private String normalizeCommandLine(ProcessHandle.Info processInfo) {
        return processInfo.commandLine().map(line -> line.replaceAll("\\r?\\n", " \\\\n")).orElse("");
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private void sortCommands(List<FallibleCommand> commandList) {
        commandList.sort((c1, c2) -> {
            int indexOf1 = this.getIndex((FallibleCommand)c1);
            int indexOf2 = this.getIndex((FallibleCommand)c2);
            if (indexOf1 == -1 || indexOf2 == -1) {
                return 0;
            }
            return indexOf1 - indexOf2;
        });
    }

    int getIndex(FallibleCommand command) {
        int index = commandOrder.indexOf(command.getClass());
        if (index != -1) {
            return index;
        }
        for (int i = 0; i < commandOrder.size(); ++i) {
            if (!commandOrder.get(i).isAssignableFrom(command.getClass())) continue;
            return i;
        }
        throw new UnknownTaskException(command);
    }

    public record NodeTasksLockInfo(long pid, String commandLine) implements Serializable
    {
    }
}

