/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.ListSignal;
import com.vaadin.signals.Signal;
import com.vaadin.signals.SignalEnvironment;
import com.vaadin.signals.ValueSignal;
import com.vaadin.signals.impl.Effect;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ComponentEffect {
    private final Runnable effectFunction;
    private boolean closed = false;
    private Effect effect = null;

    private <C extends Component> ComponentEffect(C owner, Runnable effectFunction) {
        Objects.requireNonNull(owner, "Owner component cannot be null");
        Objects.requireNonNull(effectFunction, "Effect function cannot be null");
        this.effectFunction = effectFunction;
        owner.addAttachListener(attach -> {
            this.enableEffect((Component)attach.getSource());
            owner.addDetachListener(detach -> {
                this.disableEffect();
                detach.unregisterListener();
            });
        });
        if (owner.isAttached()) {
            this.enableEffect(owner);
        }
    }

    public static <C extends Component> Registration effect(C owner, Runnable effectFunction) {
        ComponentEffect effect = new ComponentEffect(owner, effectFunction);
        return effect::close;
    }

    public static <C extends Component, T> Registration bind(C owner, Signal<T> signal, SerializableBiConsumer<C, T> setter) {
        return ComponentEffect.effect(owner, () -> setter.accept(owner, signal.value()));
    }

    public static <T, PARENT extends Component> void bindChildren(PARENT parent, ListSignal<T> list, SerializableFunction<ValueSignal<T>, Component> childFactory) {
        Objects.requireNonNull(parent, "Parent component cannot be null");
        Objects.requireNonNull(childFactory, "Child component factory cannot be null");
        ComponentEffect.bindChildren(parent, parent.getElement(), list, signalValue -> Optional.ofNullable((Component)childFactory.apply((ValueSignal)signalValue)).map(Component::getElement).orElseThrow(() -> new IllegalStateException("ComponentEffect.bindChildren childFactory must not return null")));
    }

    private static <T> void bindChildren(Component parentComponent, Element parent, ListSignal<T> list, SerializableFunction<ValueSignal<T>, Element> childFactory) {
        Objects.requireNonNull(parentComponent, "Parent component cannot be null");
        Objects.requireNonNull(parent, "Parent element cannot be null");
        Objects.requireNonNull(list, "ListSignal cannot be null");
        Objects.requireNonNull(childFactory, "Child element factory cannot be null");
        if (parent.getChildCount() > 0) {
            throw new IllegalStateException("Parent element must not have children when binding ListSignal to it");
        }
        HashMap valueSignalToChildCache = new HashMap();
        ComponentEffect.effect(parentComponent, () -> ComponentEffect.runEffect(new BindChildrenEffectContext(parent, (List)list.value(), childFactory, valueSignalToChildCache)));
    }

    private static <T> void runEffect(BindChildrenEffectContext<T> context) {
        LinkedList<Element> remainingChildren = context.parentChildrenToLinkedList();
        HashSet<Element> remainingChildrenSet = new HashSet<Element>(remainingChildren);
        if (remainingChildren.size() != context.getCachedChildrenSize()) {
            throw new IllegalStateException("Parent element must have children matching the list signal. Unexpected child count: " + remainingChildren.size() + ", expected: " + context.getCachedChildrenSize());
        }
        ComponentEffect.removeNotPresentChildren(context, remainingChildrenSet);
        ComponentEffect.updateByChildSignals(context, remainingChildren, remainingChildrenSet);
        ComponentEffect.validate(context);
    }

    private void enableEffect(Component owner) {
        if (this.closed) {
            return;
        }
        UI ui = owner.getUI().get();
        Runnable errorHandlingEffectFunction = () -> {
            try {
                this.effectFunction.run();
            }
            catch (Exception e) {
                ui.getSession().getErrorHandler().error(new ErrorEvent(e, owner.getElement().getNode()));
            }
        };
        assert (this.effect == null);
        this.effect = new Effect(errorHandlingEffectFunction, command -> {
            if (UI.getCurrent() == ui) {
                command.run();
            } else {
                SignalEnvironment.getDefaultEffectDispatcher().execute(() -> {
                    try {
                        if (this.effect != null) {
                            ui.access(command::run);
                        }
                    }
                    catch (UIDetachedException uIDetachedException) {
                        // empty catch block
                    }
                });
            }
        });
    }

    private void disableEffect() {
        if (this.effect != null) {
            this.effect.dispose();
            this.effect = null;
        }
    }

    private void close() {
        this.disableEffect();
        this.closed = true;
    }

    private static <T> void validate(BindChildrenEffectContext<T> context) {
        LinkedList<Element> children = context.parentChildrenToLinkedList();
        int index = 0;
        for (Element actualElement : children) {
            if (index >= context.childSignalsList.size()) {
                throw new IllegalStateException(String.format("Parent element must have children matching the list signal. Unexpected child at index %1$s: %2$s, expected: %3$s", index, actualElement, "none"));
            }
            Element expectedElement = context.valueSignalToChildCache.get(context.childSignalsList.get(index));
            if (!Objects.equals(actualElement, expectedElement)) {
                throw new IllegalStateException(String.format("Parent element must have children matching the list signal. Unexpected child at index %1$s: %2$s, expected: %3$s", index, actualElement, expectedElement));
            }
            ++index;
        }
        if (children.size() > context.getCachedChildrenSize()) {
            throw new IllegalStateException(String.format("Parent element must have children matching the list signal. Too many children: %1$s, expected: %2$s", children.size(), context.getCachedChildrenSize()));
        }
    }

    private static <T> void removeNotPresentChildren(BindChildrenEffectContext<T> context, HashSet<Element> remainingChildrenSet) {
        HashSet toRemove = new HashSet(context.valueSignalToChildCache.keySet());
        context.childSignalsList.forEach(toRemove::remove);
        for (ValueSignal removedItem : toRemove) {
            Element element = context.valueSignalToChildCache.remove(removedItem);
            element.removeFromParent();
            remainingChildrenSet.remove(element);
        }
    }

    private static <T> void updateByChildSignals(BindChildrenEffectContext<T> context, LinkedList<Element> remainingChildren, HashSet<Element> remainingChildrenSet) {
        for (int i = 0; i < context.childSignalsList.size(); ++i) {
            ValueSignal item = context.childSignalsList.get(i);
            Element expectedChild = context.getElement(item);
            if (remainingChildrenSet.isEmpty() || !Objects.equals(expectedChild.getParent(), context.parentElement)) {
                context.parentElement.insertChild(i, expectedChild);
                continue;
            }
            Element actualChild = remainingChildren.pollFirst();
            if (!remainingChildrenSet.contains(actualChild) || Objects.equals(actualChild, expectedChild)) continue;
            if (Objects.equals(expectedChild, remainingChildren.peek())) {
                actualChild.removeFromParent();
                remainingChildren.pollFirst();
                continue;
            }
            context.parentElement.insertChild(i, expectedChild);
            remainingChildrenSet.remove(expectedChild);
            remainingChildren.addFirst(actualChild);
        }
    }

    private record BindChildrenEffectContext<T>(Element parentElement, List<ValueSignal<T>> childSignalsList, SerializableFunction<ValueSignal<T>, Element> childElementFactory, HashMap<ValueSignal<T>, Element> valueSignalToChildCache) implements Serializable
    {
        private Element getElement(ValueSignal<T> item) {
            return this.valueSignalToChildCache.computeIfAbsent(item, this.childElementFactory);
        }

        private int getCachedChildrenSize() {
            return this.valueSignalToChildCache.size();
        }

        private LinkedList<Element> parentChildrenToLinkedList() {
            return this.parentElement.getChildren().collect(Collectors.toCollection(LinkedList::new));
        }
    }
}

