/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import com.vaadin.flow.server.streams.TransferUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamDownloadHandler
extends AbstractDownloadHandler<InputStreamDownloadHandler> {
    private final InputStreamDownloadCallback callback;

    public InputStreamDownloadHandler(InputStreamDownloadCallback callback) {
        this.callback = callback;
    }

    @Override
    public void handleDownloadRequest(DownloadEvent downloadEvent) throws IOException {
        DownloadResponse download = this.callback.complete(downloadEvent);
        VaadinResponse response = downloadEvent.getResponse();
        if (download.hasError()) {
            response.setStatus(download.getError());
            return;
        }
        String downloadName = download.getFileName();
        String contentType = download.getContentType() == null ? this.getContentType(downloadName, response) : download.getContentType();
        downloadEvent.setContentType(contentType);
        if (!this.isInline()) {
            downloadEvent.setFileName(downloadName);
        } else {
            downloadEvent.getResponse().setHeader("Content-Disposition", "inline");
        }
        try (OutputStream outputStream = downloadEvent.getOutputStream();
             InputStream inputStream = download.getInputStream();){
            TransferUtil.transfer(inputStream, outputStream, this.getTransferContext(downloadEvent), this.getListeners());
        }
        catch (IOException ioe) {
            response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
            this.notifyError(downloadEvent, ioe);
            throw ioe;
        }
    }
}

