/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.server.frontend.installer.Platform;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import java.util.function.Supplier;

public class FrontendToolsSettings
implements Serializable {
    private String baseDir;
    private SerializableSupplier<String> alternativeDirGetter;
    private String nodeVersion = "v22.16.0";
    private URI nodeDownloadRoot = URI.create(Platform.guess().getNodeDownloadRoot());
    private boolean ignoreVersionChecks;
    private boolean forceAlternativeNode = false;
    private boolean useGlobalPnpm = false;
    private boolean autoUpdate = true;

    public FrontendToolsSettings(String baseDir, SerializableSupplier<String> alternativeDirGetter) {
        this.baseDir = Objects.requireNonNull(baseDir);
        this.alternativeDirGetter = alternativeDirGetter;
        this.ignoreVersionChecks = "true".equalsIgnoreCase(System.getProperty("vaadin.ignoreVersionChecks"));
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = Objects.requireNonNull(baseDir);
    }

    public void setAlternativeDirGetter(SerializableSupplier<String> alternativeDirGetter) {
        this.alternativeDirGetter = alternativeDirGetter;
    }

    public void setNodeDownloadRoot(URI nodeDownloadRoot) {
        this.nodeDownloadRoot = nodeDownloadRoot;
    }

    public void setNodeVersion(String nodeVersion) {
        this.nodeVersion = nodeVersion;
    }

    public void setIgnoreVersionChecks(boolean ignoreVersionChecks) {
        this.ignoreVersionChecks = ignoreVersionChecks;
    }

    public void setForceAlternativeNode(boolean forceAlternativeNode) {
        this.forceAlternativeNode = forceAlternativeNode;
    }

    public void setUseGlobalPnpm(boolean useGlobalPnpm) {
        this.useGlobalPnpm = useGlobalPnpm;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public Supplier<String> getAlternativeDirGetter() {
        return this.alternativeDirGetter;
    }

    public String getNodeVersion() {
        return this.nodeVersion;
    }

    public URI getNodeDownloadRoot() {
        return this.nodeDownloadRoot;
    }

    public boolean isIgnoreVersionChecks() {
        return this.ignoreVersionChecks;
    }

    public boolean isForceAlternativeNode() {
        return this.forceAlternativeNode;
    }

    public boolean isUseGlobalPnpm() {
        return this.useGlobalPnpm;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }
}

