/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.RouteResolver;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.ResolveRequest;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class DefaultRouteResolver
implements RouteResolver {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NavigationState resolve(ResolveRequest request) {
        String path;
        RouteRegistry registry = request.getRouter().getRegistry();
        NavigationRouteTarget navigationResult = registry.getNavigationRouteTarget(path = request.getLocation().getPath());
        if (!navigationResult.hasTarget()) {
            Optional<String> clientNavigationTargetPath = RouteUtil.getClientNavigationRouteTargetTemplate(path);
            if (!clientNavigationTargetPath.isPresent()) return null;
            String clientPath = clientNavigationTargetPath.get();
            AvailableViewInfo viewInfo = MenuRegistry.getClientRoutes(false).get(clientPath.isEmpty() ? clientPath : (clientPath.startsWith("/") ? clientPath : "/" + clientPath));
            if (viewInfo == null || !viewInfo.flowLayout()) return null;
            Class<? extends RouterLayout> layout = registry.getLayout(path);
            if (layout == null) {
                throw new NotFoundException("No layout for client path '%s'".formatted(path));
            }
            RouteTarget target = new RouteTarget(layout, Collections.emptyList());
            navigationResult = new NavigationRouteTarget(navigationResult.getPath(), target, Collections.emptyMap());
        }
        NavigationStateBuilder builder = new NavigationStateBuilder(request.getRouter());
        try {
            builder.withTarget(navigationResult.getRouteTarget(), navigationResult.getRouteParameters());
            builder.withPath(navigationResult.getPath());
            return builder.build();
        }
        catch (NotFoundException nfe) {
            String message = "Exception while navigation to path " + path;
            LoggerFactory.getLogger((String)this.getClass().getName()).warn(message, (Throwable)nfe);
            throw nfe;
        }
    }
}

