/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import java.util.Optional;
import java.util.stream.Stream;

public enum Unit {
    PERCENTAGE("%"),
    PIXELS("px"),
    REM("rem"),
    EM("em"),
    VW("vw"),
    VH("vh"),
    VMIN("vmin"),
    VMAX("vmax"),
    POINTS("pt"),
    PICAS("pc"),
    EX("ex"),
    MM("mm"),
    CH("ch"),
    CM("cm"),
    INCH("in");

    private final String symbol;

    private Unit(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String toString() {
        return this.symbol;
    }

    static Stream<Unit> getUnits() {
        return Stream.of(Unit.values());
    }

    public static Optional<Unit> getUnit(String cssSize) {
        if (cssSize == null || cssSize.isEmpty()) {
            return Optional.empty();
        }
        for (Unit unit : Unit.values()) {
            if (!cssSize.endsWith(unit.getSymbol())) continue;
            return Optional.of(unit);
        }
        return Optional.empty();
    }

    public static float getSize(String cssSize) {
        if (cssSize == null || cssSize.length() < 1) {
            throw new IllegalArgumentException("The parameter can't be null");
        }
        Unit unit = Unit.getUnits().filter(value -> cssSize.endsWith(value.toString())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The parameter string '%s' does not contain valid unit", cssSize)));
        String size = cssSize.substring(0, cssSize.length() - unit.toString().length());
        if (size.isEmpty()) {
            size = "0";
        }
        return Float.valueOf(size).floatValue();
    }

    public static Unit getUnitFromSymbol(String symbol) {
        if (symbol == null) {
            return PIXELS;
        }
        for (Unit unit : Unit.values()) {
            if (!symbol.equals(unit.getSymbol())) continue;
            return unit;
        }
        return PIXELS;
    }
}

