/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import java.io.Serializable;
import java.util.HashMap;

public class Attributes
implements Serializable {
    private final HashMap<String, Object> attributes = new HashMap();

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public <T> void setAttribute(Class<T> type, T value) {
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException("value of type " + type.getName() + " expected but got " + value.getClass().getName());
        }
        this.setAttribute(type.getName(), value);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        return this.attributes.get(name);
    }

    public <T> T getAttribute(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        Object value = this.getAttribute(type.getName());
        if (value == null) {
            return null;
        }
        return type.cast(value);
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }
}

