/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.DefaultRoutePathProvider;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.DependencyTrigger;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.frontend.scanner.AbstractDependenciesScanner;
import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.ClassInfo;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.EntryPointData;
import com.vaadin.flow.server.frontend.scanner.EntryPointType;
import com.vaadin.flow.server.frontend.scanner.FrontendAnnotatedClassVisitor;
import com.vaadin.flow.server.frontend.scanner.FrontendClassVisitor;
import com.vaadin.flow.server.frontend.scanner.ThemeData;
import com.vaadin.flow.server.frontend.scanner.ThemeWrapper;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendDependencies
extends AbstractDependenciesScanner {
    private final HashMap<String, EntryPointData> entryPoints = new LinkedHashMap<String, EntryPointData>();
    private ThemeDefinition themeDefinition;
    private AbstractTheme themeInstance;
    private final HashMap<String, String> packages = new HashMap();
    private final Map<String, ClassInfo> visitedClasses = new HashMap<String, ClassInfo>();
    private PwaConfiguration pwaConfiguration;
    private Class<? extends Annotation> routeClass;
    private Set<String> eagerRoutes = null;

    public FrontendDependencies(ClassFinder finder) {
        this(finder, true, null);
    }

    public FrontendDependencies(ClassFinder finder, boolean generateEmbeddableWebComponents) {
        this(finder, generateEmbeddableWebComponents, null);
    }

    public FrontendDependencies(ClassFinder finder, boolean generateEmbeddableWebComponents, FeatureFlags featureFlags) {
        super(finder, featureFlags);
        this.log().info("Scanning classes to find frontend configurations and dependencies...");
        long start = System.nanoTime();
        try {
            Class<? extends AbstractTheme> themeClass;
            this.routeClass = this.getFinder().loadClass(Route.class.getName());
            this.computeEagerRouteConfiguration();
            this.collectEntryPoints(generateEmbeddableWebComponents);
            this.visitEntryPoints();
            this.computeApplicationTheme();
            if (this.themeDefinition != null && this.themeDefinition.getTheme() != null && !this.visitedClasses.containsKey((themeClass = this.themeDefinition.getTheme()).getName())) {
                this.addInternalEntryPoint(themeClass);
                this.visitEntryPoint(this.entryPoints.get(themeClass.getName()));
            }
            this.computePackages();
            this.computePwaConfiguration();
            this.aggregateEntryPointInformation();
            long ms = (System.nanoTime() - start) / 1000000L;
            this.log().info("Visited {} classes. Took {} ms.", (Object)this.visitedClasses.size(), (Object)ms);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Unable to compute frontend dependencies", e);
        }
    }

    private void aggregateEntryPointInformation() {
        for (Map.Entry<String, EntryPointData> entry : this.entryPoints.entrySet()) {
            EntryPointData entryPoint = entry.getValue();
            for (String className : entryPoint.reachableClasses) {
                ClassInfo classInfo = this.visitedClasses.get(className);
                entryPoint.getModules().addAll(classInfo.modules);
                entryPoint.getCss().addAll(classInfo.css);
                entryPoint.getScripts().addAll(classInfo.scripts);
            }
        }
    }

    Set<String> collectReachableClasses(EntryPointData entryPointData) {
        HashSet<String> classes = new HashSet<String>();
        this.collectReachableClasses(entryPointData.getName(), classes);
        return classes;
    }

    private void collectReachableClasses(String name, Set<String> classes) {
        if (classes.contains(name)) {
            return;
        }
        ClassInfo visitedClass = this.visitedClasses.get(name);
        if (visitedClass == null) {
            if (!this.shouldVisit(name)) {
                return;
            }
            throw new IllegalStateException("The class " + name + " is reachable but its info was not collected");
        }
        classes.add(name);
        for (String className : visitedClass.children) {
            if (this.entryPoints.containsKey(className)) continue;
            this.collectReachableClasses(className, classes);
        }
    }

    private void visitEntryPoints() throws IOException {
        for (Map.Entry<String, EntryPointData> entry : this.entryPoints.entrySet()) {
            this.visitEntryPoint(entry.getValue());
        }
    }

    private void visitEntryPoint(EntryPointData entryPoint) throws IOException {
        this.visitClass(entryPoint.getName(), entryPoint);
        entryPoint.reachableClasses = this.collectReachableClasses(entryPoint);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Classes reachable from " + entryPoint.getName() + ": " + entryPoint.reachableClasses);
        }
    }

    @Override
    public Map<String, String> getPackages() {
        return this.packages;
    }

    @Override
    public PwaConfiguration getPwaConfiguration() {
        return this.pwaConfiguration;
    }

    @Override
    public Map<ChunkInfo, List<String>> getModules() {
        LinkedHashMap<ChunkInfo, List<String>> all = new LinkedHashMap<ChunkInfo, List<String>>();
        for (EntryPointData data : this.entryPoints.values()) {
            all.computeIfAbsent(this.getChunkInfo(data), k -> new ArrayList()).addAll(data.getModules());
        }
        return all;
    }

    private ChunkInfo getChunkInfo(EntryPointData data) {
        if (data.getType() == EntryPointType.INTERNAL) {
            return ChunkInfo.GLOBAL;
        }
        return new ChunkInfo(data.getType(), data.getName(), data.getDependencyTriggers(), data.isEager());
    }

    @Override
    public Map<ChunkInfo, List<String>> getScripts() {
        LinkedHashMap<ChunkInfo, List<String>> all = new LinkedHashMap<ChunkInfo, List<String>>();
        for (EntryPointData data : this.entryPoints.values()) {
            all.computeIfAbsent(this.getChunkInfo(data), k -> new ArrayList()).addAll(data.getScripts());
        }
        return all;
    }

    @Override
    public Map<ChunkInfo, List<CssData>> getCss() {
        LinkedHashMap<ChunkInfo, List<CssData>> all = new LinkedHashMap<ChunkInfo, List<CssData>>();
        for (EntryPointData data : this.entryPoints.values()) {
            all.computeIfAbsent(this.getChunkInfo(data), k -> new ArrayList()).addAll(data.getCss());
        }
        return all;
    }

    @Override
    public Set<String> getClasses() {
        return this.visitedClasses.keySet();
    }

    public Collection<EntryPointData> getEntryPoints() {
        return this.entryPoints.values();
    }

    @Override
    public ThemeDefinition getThemeDefinition() {
        return this.themeDefinition;
    }

    @Override
    public AbstractTheme getTheme() {
        return this.themeInstance;
    }

    private void collectEntryPoints(boolean generateEmbeddableWebComponents) throws ClassNotFoundException {
        Class triggerClass = this.getFinder().loadClass(DependencyTrigger.class.getName());
        for (Class<?> clazz : this.getFinder().getAnnotatedClasses(this.routeClass)) {
            List<String> triggerClasses = this.getDependencyTriggers(clazz, triggerClass);
            boolean eager = this.isEagerRoute(clazz);
            this.addEntryPoint(clazz, EntryPointType.ROUTE, triggerClasses, eager);
        }
        for (Class<Object> clazz : this.getFinder().getSubTypesOf(this.getFinder().loadClass(UIInitListener.class.getName()))) {
            this.addInternalEntryPoint(clazz);
        }
        for (Class<Object> clazz : this.getFinder().getSubTypesOf(this.getFinder().loadClass(VaadinServiceInitListener.class.getName()))) {
            this.addInternalEntryPoint(clazz);
        }
        for (Class<Object> clazz : this.getFinder().getSubTypesOf(this.getFinder().loadClass(AppShellConfigurator.class.getName()))) {
            this.addInternalEntryPoint(clazz);
        }
        for (Class<Object> clazz : this.getFinder().getSubTypesOf(this.getFinder().loadClass(HasErrorParameter.class.getName()))) {
            this.addInternalEntryPoint(clazz);
        }
        this.addInternalEntryPoint(UI.class);
        if (generateEmbeddableWebComponents) {
            this.collectExporterEntrypoints(WebComponentExporter.class);
            this.collectExporterEntrypoints(WebComponentExporterFactory.class);
        }
    }

    private boolean isEagerRoute(Class<?> route) {
        if (this.eagerRoutes == null) {
            return this.defaultIsRouteEager(route);
        }
        if (this.eagerRoutes.isEmpty()) {
            return true;
        }
        return this.eagerRoutes.contains(route.getName());
    }

    private boolean defaultIsRouteEager(Class<?> route) {
        try {
            Annotation routeAnnotation = route.getAnnotation(this.routeClass);
            Method valueMethod = this.routeClass.getMethod("value", new Class[0]);
            String annotationRoutePath = (String)valueMethod.invoke((Object)routeAnnotation, new Object[0]);
            String routePath = DefaultRoutePathProvider.getRoutePath(annotationRoutePath, route);
            boolean eagerRoute = "".equals(routePath) || "login".equals(routePath);
            return eagerRoute;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.log().error("Unable to read @Route annotation for " + route.getName(), (Throwable)e);
            return false;
        }
    }

    private List<String> getDependencyTriggers(Class<?> route, Class triggerClass) {
        try {
            Method valueMethod;
            Class[] triggers;
            Object triggerAnnotation = route.getAnnotation(triggerClass);
            if (triggerAnnotation != null && (triggers = (Class[])(valueMethod = triggerClass.getMethod("value", new Class[0])).invoke(triggerAnnotation, new Object[0])) != null) {
                return Stream.of(triggers).map(cls -> cls.getName()).toList();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.log().warn("Unable to determine load mode for route class {}. Using eager.", (Object)route.getName(), (Object)e);
        }
        return null;
    }

    private void addInternalEntryPoint(Class<?> entryPointClass) {
        this.addEntryPoint(entryPointClass, EntryPointType.INTERNAL, null, true);
    }

    private void addEntryPoint(Class<?> entryPointClass, EntryPointType type, List<String> dependencyTriggers, boolean eager) {
        String className = entryPointClass.getName();
        if (this.entryPoints.containsKey(className)) {
            return;
        }
        EntryPointData data = new EntryPointData(entryPointClass, type, dependencyTriggers, eager);
        this.entryPoints.put(className, data);
    }

    private void computeApplicationTheme() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        List<ClassInfo> classesWithTheme = this.entryPoints.values().stream().flatMap(entryPoint -> entryPoint.reachableClasses.stream()).map(className -> this.visitedClasses.get(className)).filter(this::hasThemeInfo).toList();
        Set themes = classesWithTheme.stream().map(classInfo -> classInfo.theme).collect(Collectors.toSet());
        if (themes.size() > 1) {
            String names = classesWithTheme.stream().map(data -> "found '" + this.getThemeDescription(data.theme) + "' in '" + data.className + "'").collect(Collectors.joining("\n      "));
            throw new IllegalStateException("\n Multiple Theme configuration is not supported:\n      " + names);
        }
        Class<AbstractTheme> theme = null;
        String variant = "";
        String themeName = "";
        if (themes.isEmpty()) {
            theme = this.getDefaultTheme();
        } else {
            ThemeData themeData = (ThemeData)themes.iterator().next();
            if (!themeData.isNotheme()) {
                String themeClass = themeData.getThemeClass();
                if (!themeData.getThemeName().isEmpty() && themeClass != null) {
                    throw new IllegalStateException("Theme name and theme class can not both be specified. Theme name uses Lumo and can not be used in combination with custom theme class.");
                }
                variant = themeData.getVariant();
                if (themeClass != null) {
                    theme = this.getFinder().loadClass(themeClass);
                } else {
                    theme = this.getDefaultTheme();
                    if (theme == null) {
                        throw new IllegalStateException("Lumo dependency needs to be available on the classpath when using a theme name.");
                    }
                }
                themeName = themeData.getThemeName();
            }
        }
        if (theme != null) {
            this.themeDefinition = new ThemeDefinition(theme, variant, themeName);
            this.themeInstance = new ThemeWrapper(theme);
        }
    }

    private String getThemeDescription(ThemeData theme) {
        if (theme.isNotheme()) {
            return NoTheme.class.getName();
        }
        if (theme.getThemeName() != null && !theme.getThemeName().isBlank()) {
            return theme.getThemeName();
        }
        return theme.getThemeClass();
    }

    Class<? extends AbstractTheme> getDefaultTheme() throws IOException {
        return this.getLumoTheme();
    }

    private void computePackages() throws ClassNotFoundException, IOException {
        FrontendAnnotatedClassVisitor npmPackageVisitor = new FrontendAnnotatedClassVisitor(this.getFinder(), NpmPackage.class.getName());
        for (Class<?> component : this.getFinder().getAnnotatedClasses(NpmPackage.class.getName())) {
            npmPackageVisitor.visitClass(component.getName());
        }
        Set dependencies = npmPackageVisitor.getValues("value");
        for (String dependency : dependencies) {
            Set versions = npmPackageVisitor.getValuesForKey("value", dependency, "version");
            String version = (String)versions.iterator().next();
            if (versions.size() > 1) {
                String foundVersions = versions.toString();
                this.log().warn("Multiple npm versions for {} found:  {}. First version found '{}' will be considered.", new Object[]{dependency, foundVersions, version});
            }
            this.packages.put(dependency, version);
        }
    }

    private void computeEagerRouteConfiguration() throws ClassNotFoundException {
        FrontendAnnotatedClassVisitor loadDependenciesOnStartupVisitor = new FrontendAnnotatedClassVisitor(this.getFinder(), LoadDependenciesOnStartup.class.getName());
        Class appShellConfiguratorClass = this.getFinder().loadClass(AppShellConfigurator.class.getName());
        for (Class<?> hopefullyAppShellClass : this.getFinder().getAnnotatedClasses(LoadDependenciesOnStartup.class.getName())) {
            if (!Arrays.asList(hopefullyAppShellClass.getInterfaces()).contains(appShellConfiguratorClass)) {
                throw new IllegalStateException(ERROR_INVALID_LOAD_DEPENDENCIES_ANNOTATION);
            }
            loadDependenciesOnStartupVisitor.visitClass(hopefullyAppShellClass.getName());
            List eagerViews = (List)loadDependenciesOnStartupVisitor.getValue("value");
            if (eagerViews == null) continue;
            this.eagerRoutes = new HashSet<String>();
            for (Type eagerView : eagerViews) {
                this.eagerRoutes.add(eagerView.getClassName());
            }
        }
    }

    private void computePwaConfiguration() throws ClassNotFoundException {
        FrontendAnnotatedClassVisitor pwaVisitor = new FrontendAnnotatedClassVisitor(this.getFinder(), PWA.class.getName());
        Class appShellConfiguratorClass = this.getFinder().loadClass(AppShellConfigurator.class.getName());
        for (Class<?> hopefullyAppShellClass : this.getFinder().getAnnotatedClasses(PWA.class.getName())) {
            if (!Arrays.asList(hopefullyAppShellClass.getInterfaces()).contains(appShellConfiguratorClass)) {
                throw new IllegalStateException(ERROR_INVALID_PWA_ANNOTATION);
            }
            pwaVisitor.visitClass(hopefullyAppShellClass.getName());
        }
        Set dependencies = pwaVisitor.getValues("name");
        if (dependencies.size() > 1) {
            throw new IllegalStateException(ERROR_INVALID_PWA_ANNOTATION);
        }
        if (dependencies.isEmpty()) {
            this.pwaConfiguration = new PwaConfiguration();
            return;
        }
        String name = (String)pwaVisitor.getValue("name");
        String shortName = (String)pwaVisitor.getValue("shortName");
        String description = (String)pwaVisitor.getValue("description");
        String backgroundColor = (String)pwaVisitor.getValue("backgroundColor");
        String themeColor = (String)pwaVisitor.getValue("themeColor");
        String iconPath = (String)pwaVisitor.getValue("iconPath");
        String manifestPath = (String)pwaVisitor.getValue("manifestPath");
        String offlinePath = (String)pwaVisitor.getValue("offlinePath");
        String display = (String)pwaVisitor.getValue("display");
        String startPath = (String)pwaVisitor.getValue("startPath");
        List offlineResources = (List)pwaVisitor.getValue("offlineResources");
        boolean offline = (Boolean)pwaVisitor.getValue("offline");
        this.pwaConfiguration = new PwaConfiguration(true, name, shortName, description, backgroundColor, themeColor, iconPath, manifestPath, offlinePath, display, startPath, offlineResources.toArray(new String[0]), offline);
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private void collectExporterEntrypoints(Class<?> clazz) throws ClassNotFoundException {
        Class routeClass = this.getFinder().loadClass(Route.class.getName());
        Class exporterClass = this.getFinder().loadClass(clazz.getName());
        Set exporterClasses = this.getFinder().getSubTypesOf(exporterClass);
        if (exporterClasses.isEmpty()) {
            return;
        }
        HashMap exportedPoints = new HashMap();
        for (Class exporter : exporterClasses) {
            Class<?> componentClass;
            String exporterClassName = exporter.getName();
            if (!this.entryPoints.containsKey(exporterClassName)) {
                this.addEntryPoint(exporter, EntryPointType.WEB_COMPONENT, null, true);
            }
            if (Modifier.isAbstract(exporter.getModifiers()) || (componentClass = ReflectTools.getGenericInterfaceType(exporter, exporterClass)) == null || componentClass.isAnnotationPresent(routeClass)) continue;
            this.addEntryPoint(componentClass, EntryPointType.WEB_COMPONENT, null, true);
        }
        this.entryPoints.putAll(exportedPoints);
    }

    void visitClass(String className, EntryPointData entryPoint) throws IOException {
        if (this.visitedClasses.containsKey(className) || !this.shouldVisit(className)) {
            return;
        }
        ClassInfo info = new ClassInfo(className);
        this.visitedClasses.put(className, info);
        URL url = this.getUrl(className);
        if (url == null) {
            return;
        }
        FrontendClassVisitor visitor = new FrontendClassVisitor(info);
        try (InputStream is = url.openStream();){
            ClassReader cr = new ClassReader(is);
            cr.accept((ClassVisitor)visitor, 8);
        }
        catch (Exception e) {
            this.log().error("Visiting class {} failed with {}.\nThis might be a broken class in the project.", (Object)className, (Object)e.getMessage());
            throw e;
        }
        for (String clazz : info.children) {
            this.visitClass(clazz, entryPoint);
        }
    }

    private boolean shouldVisit(String className) {
        return className != null && !this.isExperimental(className) && !className.matches("(^$|.*(slf4j).*|^(java|sun|elemental|javax|jakarta|oshi|org.(apache|atmosphere|jsoup|jboss|w3c|spring|joda|hibernate|glassfish|hsqldb)|com.(helger|spring|gwt|lowagie|fasterxml|sun|nimbusds)|net.(sf|bytebuddy)).*|.*(Exception)$)");
    }

    private URL getUrl(String className) {
        return this.getFinder().getResource(className.replace(".", "/") + ".class");
    }

    public String toString() {
        return this.entryPoints.toString();
    }

    private boolean hasThemeInfo(ClassInfo classInfo) {
        ThemeData theme = classInfo.theme;
        if (theme.getThemeClass() != null) {
            return true;
        }
        if (theme.getThemeName() != null && !theme.getThemeName().isBlank()) {
            return true;
        }
        if (!theme.getVariant().isEmpty()) {
            return true;
        }
        return theme.isNotheme();
    }
}

