/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class TaskUpdatePackages
extends NodeUpdater {
    protected static final String VAADIN_APP_PACKAGE_HASH = "vaadinAppPackageHash";
    private final boolean forceCleanUp;
    private final boolean enablePnpm;
    private File jarResourcesFolder;

    TaskUpdatePackages(ClassFinder finder, FrontendDependenciesScanner frontendDependencies, Options options) {
        super(finder, frontendDependencies, options);
        this.jarResourcesFolder = options.getJarFrontendResourcesFolder();
        this.forceCleanUp = options.isCleanNpmFiles();
        this.enablePnpm = options.isEnablePnpm();
    }

    @Override
    public void execute() {
        try {
            Map<String, String> scannedApplicationDependencies = this.frontDeps.getPackages();
            JsonObject packageJson = this.getPackageJson();
            this.modified = this.updatePackageJsonDependencies(packageJson, scannedApplicationDependencies);
            this.generateVersionsJson(packageJson);
            boolean npmVersionLockingUpdated = this.lockVersionForNpm(packageJson);
            if (this.modified || npmVersionLockingUpdated) {
                this.writePackageFile(packageJson);
                if (this.enablePnpm) {
                    this.deletePnpmLockFile();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    boolean lockVersionForNpm(JsonObject packageJson) throws IOException {
        if (this.enablePnpm) {
            return false;
        }
        boolean versionLockingUpdated = false;
        JsonObject overridesSection = this.getOverridesSection(packageJson);
        JsonObject dependencies = packageJson.getObject("dependencies");
        for (String dependency : this.versionsJson.keys()) {
            if (overridesSection.hasKey(dependency) || !this.shouldLockDependencyVersion(dependency, dependencies, this.versionsJson)) continue;
            overridesSection.put(dependency, "$" + dependency);
            versionLockingUpdated = true;
        }
        JsonObject devDependencies = packageJson.getObject("devDependencies");
        for (String dependency : overridesSection.keys()) {
            if (dependencies.hasKey(dependency) || devDependencies.hasKey(dependency) || !overridesSection.getString(dependency).startsWith("$")) continue;
            overridesSection.remove(dependency);
            versionLockingUpdated = true;
        }
        return versionLockingUpdated;
    }

    private boolean shouldLockDependencyVersion(String dependency, JsonObject projectDependencies, JsonObject versionsJson) {
        String platformDefinedVersion = versionsJson.getString(dependency);
        if (this.isInternalPseudoDependency(platformDefinedVersion)) {
            return false;
        }
        if (projectDependencies.hasKey(dependency)) {
            try {
                new FrontendVersion(projectDependencies.getString(dependency));
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return "chokidar".equals(dependency);
    }

    private boolean isInternalPseudoDependency(String dependencyVersion) {
        return dependencyVersion != null && dependencyVersion.startsWith("./" + this.options.getBuildDirectoryName());
    }

    private JsonObject getOverridesSection(JsonObject packageJson) {
        JsonObject overridesSection = packageJson.getObject("overrides");
        if (overridesSection == null) {
            overridesSection = Json.createObject();
            packageJson.put("overrides", (JsonValue)overridesSection);
        }
        return overridesSection;
    }

    @Override
    String writePackageFile(JsonObject json) throws IOException {
        this.sortObject(json, "dependencies");
        this.sortObject(json, "devDependencies");
        this.sortObject(json, "vaadin");
        return super.writePackageFile(json);
    }

    private void sortObject(JsonObject json, String key) {
        if (!json.hasKey(key)) {
            return;
        }
        JsonObject object = (JsonObject)json.get(key);
        JsonObject ordered = this.orderKeys(object);
        Stream.of(object.keys()).forEach(arg_0 -> ((JsonObject)object).remove(arg_0));
        Stream.of(ordered.keys()).forEach(prop -> {
            JsonValue value = ordered.get(prop);
            object.put(prop, value);
        });
    }

    private JsonObject orderKeys(JsonObject object) {
        Object[] keys = object.keys();
        Arrays.sort(keys);
        JsonObject result = Json.createObject();
        for (Object key : keys) {
            JsonValue value = object.get((String)key);
            if (value instanceof JsonObject) {
                value = this.orderKeys((JsonObject)value);
            }
            result.put((String)key, value);
        }
        return result;
    }

    private boolean updatePackageJsonDependencies(JsonObject packageJson, Map<String, String> applicationDependencies) throws IOException {
        int added = 0;
        for (Map.Entry<String, String> dep : applicationDependencies.entrySet()) {
            added += this.addDependency(packageJson, "dependencies", dep.getKey(), dep.getValue());
        }
        ArrayList<String> pinnedPlatformDependencies = new ArrayList<String>();
        JsonObject platformPinnedDependencies = this.getPlatformPinnedDependencies();
        for (String key : platformPinnedDependencies.keys()) {
            if (!applicationDependencies.containsKey(key) && TaskUpdatePackages.pinPlatformDependency(packageJson, platformPinnedDependencies, key)) {
                ++added;
            }
            pinnedPlatformDependencies.add(key);
        }
        if (added > 0) {
            this.log().debug("Added {} dependencies to main package.json", (Object)added);
        }
        List<String> dependencyCollection = Stream.concat(applicationDependencies.entrySet().stream(), TaskUpdatePackages.getDefaultDependencies().entrySet().stream()).map(Map.Entry::getKey).collect(Collectors.toList());
        dependencyCollection.addAll(pinnedPlatformDependencies);
        boolean doCleanUp = this.forceCleanUp;
        int removed = this.removeLegacyProperties(packageJson);
        removed += this.cleanDependencies(dependencyCollection, packageJson, "dependencies");
        doCleanUp = doCleanUp || !this.enablePnpm && this.isPlatformVersionUpdated();
        dependencyCollection = new ArrayList<String>(this.getDefaultDevDependencies().keySet());
        int removedDev = 0;
        removedDev = this.cleanDependencies(dependencyCollection, packageJson, "devDependencies");
        if (removed > 0) {
            this.log().debug("Removed {} dependencies", (Object)removed);
        }
        if (removedDev > 0) {
            this.log().debug("Removed {} devDependencies", (Object)removedDev);
        }
        if (doCleanUp) {
            this.cleanUp();
        }
        String oldHash = packageJson.getObject("vaadin").getString("hash");
        String newHash = TaskUpdatePackages.generatePackageJsonHash(packageJson);
        packageJson.getObject("vaadin").put("hash", newHash);
        return added > 0 || removed > 0 || removedDev > 0 || !oldHash.equals(newHash);
    }

    private int cleanDependencies(List<String> dependencyCollection, JsonObject packageJson, String dependencyKey) {
        int removed = 0;
        JsonObject dependencyObject = packageJson.getObject(dependencyKey);
        JsonObject vaadinDependencyObject = packageJson.getObject("vaadin").getObject(dependencyKey);
        if (dependencyObject != null) {
            for (String key : dependencyObject.keys()) {
                if (dependencyCollection.contains(key) || !vaadinDependencyObject.hasKey(key)) continue;
                dependencyObject.remove(key);
                vaadinDependencyObject.remove(key);
                this.log().debug("Removed \"{}\".", (Object)key);
                ++removed;
            }
        }
        return removed;
    }

    protected static boolean pinPlatformDependency(JsonObject packageJson, JsonObject platformPinnedVersions, String pkg) {
        FrontendVersion platformPinnedVersion = FrontendUtils.getPackageVersionFromJson(platformPinnedVersions, pkg, "vaadin_dependencies.json");
        if (platformPinnedVersion == null) {
            return false;
        }
        JsonObject vaadinDeps = packageJson.getObject("vaadin").getObject("dependencies");
        JsonObject packageJsonDeps = packageJson.getObject("dependencies");
        assert (vaadinDeps != null) : "vaadin{ dependencies { } } should exist";
        assert (packageJsonDeps != null) : "dependencies { } should exist";
        FrontendVersion packageJsonVersion = null;
        FrontendVersion vaadinDepsVersion = null;
        try {
            if (packageJsonDeps.hasKey(pkg)) {
                packageJsonVersion = new FrontendVersion(packageJsonDeps.getString(pkg));
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        try {
            if (vaadinDeps.hasKey(pkg)) {
                vaadinDepsVersion = new FrontendVersion(vaadinDeps.getString(pkg));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (platformPinnedVersion.equals(packageJsonVersion) && platformPinnedVersion.equals(vaadinDepsVersion)) {
            return false;
        }
        packageJsonDeps.put(pkg, platformPinnedVersion.getFullVersion());
        vaadinDeps.put(pkg, platformPinnedVersion.getFullVersion());
        return true;
    }

    private boolean isPlatformVersionUpdated() throws IOException {
        Optional<String> platformVersion = TaskUpdatePackages.getVaadinVersion(this.finder);
        if (platformVersion.isPresent() && this.options.getNodeModulesFolder().exists()) {
            JsonObject vaadinJsonContents = this.getVaadinJsonContents();
            if (!vaadinJsonContents.hasKey("vaadinVersion")) {
                return true;
            }
            return !Objects.equals(vaadinJsonContents.getString("vaadinVersion"), platformVersion.get());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<String> getVaadinVersion(ClassFinder finder) {
        URL coreVersionsResource = finder.getResource("vaadin-core-versions.json");
        if (coreVersionsResource == null) {
            return Optional.empty();
        }
        try (InputStream vaadinVersionsStream = coreVersionsResource.openStream();){
            JsonObject versionsJson = Json.parse((String)IOUtils.toString((InputStream)vaadinVersionsStream, (Charset)StandardCharsets.UTF_8));
            if (!versionsJson.hasKey("platform")) return Optional.empty();
            Optional<String> optional = Optional.of(versionsJson.getString("platform"));
            return optional;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Platform.class).error("Unable to determine version information", (Throwable)e);
        }
        return Optional.empty();
    }

    private int removeLegacyProperties(JsonObject packageJson) throws IOException {
        int result = 0;
        if (packageJson.hasKey("dependencies")) {
            JsonObject object = packageJson.getObject("dependencies");
            if (object.hasKey("@vaadin/flow-deps")) {
                object.remove("@vaadin/flow-deps");
                this.log().debug("Removed \"{}\" as it's not generated anymore.", (Object)"@vaadin/flow-deps");
                ++result;
            }
            if (object.hasKey("@vaadin/flow-frontend")) {
                object.remove("@vaadin/flow-frontend");
                this.log().debug("Removed \"{}\" as it's not needed anymore.", (Object)"@vaadin/flow-frontend");
                ++result;
            }
        }
        if (packageJson.hasKey(VAADIN_APP_PACKAGE_HASH)) {
            packageJson.remove(VAADIN_APP_PACKAGE_HASH);
            this.log().debug("Removed \"{}\" as it's not used.", (Object)VAADIN_APP_PACKAGE_HASH);
            ++result;
        }
        if (!this.enablePnpm) {
            return result;
        }
        File packageLockFile = this.getPackageLockFile();
        if (packageLockFile.exists()) {
            FileUtils.forceDelete((File)this.getPackageLockFile());
        }
        return result;
    }

    private void cleanUp() throws IOException {
        FrontendUtils.deleteNodeModules(this.options.getNodeModulesFolder());
        if (this.jarResourcesFolder != null && this.jarResourcesFolder.exists()) {
            for (File file : this.jarResourcesFolder.listFiles()) {
                file.delete();
            }
        }
    }

    private void deletePnpmLockFile() throws IOException {
        File lockFile = new File(this.options.getNpmFolder(), "pnpm-lock.yaml");
        if (lockFile.exists()) {
            FileUtils.forceDelete((File)lockFile);
        }
    }

    static String generatePackageJsonHash(JsonObject packageJson) {
        StringBuilder hashContent = new StringBuilder();
        if (packageJson.hasKey("dependencies")) {
            JsonObject dependencies = packageJson.getObject("dependencies");
            hashContent.append("\"dependencies\": {");
            String sortedDependencies = Arrays.stream(dependencies.keys()).sorted(String::compareToIgnoreCase).map(key -> String.format("\"%s\": \"%s\"", key, dependencies.getString(key))).collect(Collectors.joining(",\n  "));
            hashContent.append(sortedDependencies);
            hashContent.append("}");
        }
        if (packageJson.hasKey("devDependencies")) {
            if (hashContent.length() > 0) {
                hashContent.append(",\n");
            }
            JsonObject devDependencies = packageJson.getObject("devDependencies");
            hashContent.append("\"devDependencies\": {");
            String sortedDevDependencies = Arrays.stream(devDependencies.keys()).sorted(String::compareToIgnoreCase).map(key -> String.format("\"%s\": \"%s\"", key, devDependencies.getString(key))).collect(Collectors.joining(",\n  "));
            hashContent.append(sortedDevDependencies);
            hashContent.append("}");
        }
        return StringUtil.getHash(hashContent.toString());
    }
}

