/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.server.frontend.scanner.EntryPointType;
import java.util.Collections;
import java.util.List;

public class ChunkInfo {
    public static final ChunkInfo GLOBAL = new ChunkInfo(EntryPointType.INTERNAL, null, null, false);
    private final EntryPointType type;
    private final String name;
    private List<String> dependencyTriggers = null;
    private final boolean eager;

    public ChunkInfo(EntryPointType type, String name, List<String> dependencyTriggers, boolean eager) {
        this.type = type;
        this.eager = eager;
        if (type == EntryPointType.INTERNAL) {
            this.name = null;
        } else {
            this.name = name;
            this.dependencyTriggers = dependencyTriggers;
        }
    }

    public EntryPointType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkInfo other = (ChunkInfo)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public List<String> getDependencyTriggers() {
        if (this.dependencyTriggers != null) {
            return this.dependencyTriggers;
        }
        return Collections.singletonList(this.getName());
    }

    public boolean isEager() {
        return this.eager;
    }
}

