/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.EndpointGeneratorTaskFactory;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendWebComponentGenerator;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCopyFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyTemplateFiles;
import com.vaadin.flow.server.frontend.TaskGenerateBootstrap;
import com.vaadin.flow.server.frontend.TaskGenerateEndpoint;
import com.vaadin.flow.server.frontend.TaskGenerateFeatureFlags;
import com.vaadin.flow.server.frontend.TaskGenerateIndexHtml;
import com.vaadin.flow.server.frontend.TaskGenerateIndexTs;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import com.vaadin.flow.server.frontend.TaskGeneratePackageJson;
import com.vaadin.flow.server.frontend.TaskGenerateServiceWorker;
import com.vaadin.flow.server.frontend.TaskGenerateTsConfig;
import com.vaadin.flow.server.frontend.TaskGenerateTsDefinitions;
import com.vaadin.flow.server.frontend.TaskGenerateViteDevMode;
import com.vaadin.flow.server.frontend.TaskGenerateWebComponentBootstrap;
import com.vaadin.flow.server.frontend.TaskGenerateWebComponentHtml;
import com.vaadin.flow.server.frontend.TaskInstallFrontendBuildPlugins;
import com.vaadin.flow.server.frontend.TaskRunDevBundleBuild;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.TaskUpdateImports;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.TaskUpdateSettingsFile;
import com.vaadin.flow.server.frontend.TaskUpdateThemeImport;
import com.vaadin.flow.server.frontend.TaskUpdateVite;
import com.vaadin.flow.server.frontend.UnknownTaskException;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class NodeTasks
implements FallibleCommand {
    private static final List<Class<? extends FallibleCommand>> commandOrder = Collections.unmodifiableList(Arrays.asList(TaskGeneratePackageJson.class, TaskGenerateIndexHtml.class, TaskGenerateIndexTs.class, TaskGenerateViteDevMode.class, TaskGenerateTsConfig.class, TaskGenerateTsDefinitions.class, TaskGenerateServiceWorker.class, TaskGenerateBootstrap.class, TaskGenerateWebComponentHtml.class, TaskGenerateWebComponentBootstrap.class, TaskGenerateFeatureFlags.class, TaskInstallFrontendBuildPlugins.class, TaskUpdatePackages.class, TaskRunNpmInstall.class, TaskGenerateOpenAPI.class, TaskGenerateEndpoint.class, TaskCopyFrontendFiles.class, TaskCopyLocalFrontendFiles.class, TaskUpdateSettingsFile.class, TaskUpdateVite.class, TaskUpdateImports.class, TaskUpdateThemeImport.class, TaskCopyTemplateFiles.class, TaskRunDevBundleBuild.class));
    private final List<FallibleCommand> commands = new ArrayList<FallibleCommand>();

    public NodeTasks(Options options) {
        PwaConfiguration pwa;
        ClassFinder.CachedClassFinder classFinder = new ClassFinder.CachedClassFinder(options.getClassFinder());
        FrontendDependenciesScanner frontendDependencies = null;
        HashSet<String> webComponentTags = new HashSet();
        FeatureFlags featureFlags = options.getFeatureFlags();
        if (options.isFrontendHotdeploy()) {
            UsageStatistics.markAsUsed("flow/hotdeploy", null);
        }
        if (options.isEnablePackagesUpdate() || options.isEnableImportsUpdate() || options.isEnableWebpackConfigUpdate()) {
            FrontendWebComponentGenerator generator;
            Set<File> webComponents;
            frontendDependencies = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(!options.isUseByteCodeScanner(), classFinder, options.isGenerateEmbeddableWebComponents(), featureFlags);
            if (!options.isProductionMode() && options.isDevBundleBuild()) {
                if (TaskRunDevBundleBuild.needsBuild(options, frontendDependencies, classFinder)) {
                    options.withRunNpmInstall(true);
                    options.withCopyTemplates(true);
                    UsageStatistics.markAsUsed("flow/app-dev-bundle", null);
                } else {
                    options.withDevBundleBuild(false);
                    File devBundleFolder = FrontendUtils.getDevBundleFolder(options.getNpmFolder());
                    if (devBundleFolder.exists()) {
                        UsageStatistics.markAsUsed("flow/app-dev-bundle", null);
                    } else {
                        UsageStatistics.markAsUsed("flow/dev-bundle", null);
                    }
                }
            }
            if (options.isGenerateEmbeddableWebComponents() && (webComponents = (generator = new FrontendWebComponentGenerator(classFinder)).generateWebComponents(options.getGeneratedFolder(), frontendDependencies.getThemeDefinition())).size() > 0) {
                this.commands.add(new TaskGenerateWebComponentHtml(options));
                this.commands.add(new TaskGenerateWebComponentBootstrap(options));
                webComponentTags = webComponents.stream().map(webComponentPath -> FilenameUtils.removeExtension((String)webComponentPath.getName())).collect(Collectors.toSet());
            }
            TaskUpdatePackages packageUpdater = null;
            if (options.isEnablePackagesUpdate() && options.getJarFrontendResourcesFolder() != null) {
                packageUpdater = new TaskUpdatePackages(classFinder, frontendDependencies, options);
                this.commands.add(packageUpdater);
            }
            if (packageUpdater != null && options.isRunNpmInstall()) {
                this.commands.add(new TaskRunNpmInstall(packageUpdater, options));
                this.commands.add(new TaskInstallFrontendBuildPlugins(options));
            }
            if (packageUpdater != null && options.isDevBundleBuild()) {
                this.commands.add(new TaskRunDevBundleBuild(options));
            }
        }
        if (options.isCreateMissingPackageJson()) {
            TaskGeneratePackageJson packageCreator = new TaskGeneratePackageJson(options);
            this.commands.add(packageCreator);
        }
        if (frontendDependencies != null) {
            this.addGenerateServiceWorkerTask(options, frontendDependencies.getPwaConfiguration());
            if (options.isProductionMode() || options.isFrontendHotdeploy() || options.isDevBundleBuild()) {
                this.addGenerateTsConfigTask(options);
            }
        }
        this.addBootstrapTasks(options);
        this.addEndpointServicesTasks(options);
        this.commands.add(new TaskGenerateBootstrap(frontendDependencies, options));
        this.commands.add(new TaskGenerateFeatureFlags(options));
        if (options.getJarFiles() != null && options.getJarFrontendResourcesFolder() != null) {
            this.commands.add(new TaskCopyFrontendFiles(options));
        }
        if (options.getLocalResourcesFolder() != null && options.getJarFrontendResourcesFolder() != null) {
            this.commands.add(new TaskCopyLocalFrontendFiles(options));
        }
        String themeName = "";
        if (frontendDependencies != null) {
            if (frontendDependencies.getThemeDefinition() != null) {
                themeName = frontendDependencies.getThemeDefinition().getName();
            }
            pwa = frontendDependencies.getPwaConfiguration();
        } else {
            pwa = new PwaConfiguration();
        }
        this.commands.add(new TaskUpdateSettingsFile(options, themeName, pwa));
        if (options.isProductionMode() || options.isFrontendHotdeploy() || options.isDevBundleBuild()) {
            this.commands.add(new TaskUpdateVite(options, webComponentTags));
        }
        if (options.isEnableImportsUpdate()) {
            this.commands.add(new TaskUpdateImports(classFinder, frontendDependencies, finder -> this.getFallbackScanner(options, (ClassFinder)finder, featureFlags), options));
            this.commands.add(new TaskUpdateThemeImport(frontendDependencies.getThemeDefinition(), options));
        }
        if (options.isCopyTemplates()) {
            this.commands.add(new TaskCopyTemplateFiles(classFinder, options));
        }
    }

    private void addBootstrapTasks(Options options) {
        this.commands.add(new TaskGenerateIndexHtml(options));
        if (options.isProductionMode() || options.isFrontendHotdeploy() || options.isDevBundleBuild()) {
            this.commands.add(new TaskGenerateIndexTs(options));
            if (!options.isProductionMode()) {
                this.commands.add(new TaskGenerateViteDevMode(options));
            }
        }
    }

    private void addGenerateTsConfigTask(Options options) {
        TaskGenerateTsConfig taskGenerateTsConfig = new TaskGenerateTsConfig(options);
        this.commands.add(taskGenerateTsConfig);
        TaskGenerateTsDefinitions taskGenerateTsDefinitions = new TaskGenerateTsDefinitions(options);
        this.commands.add(taskGenerateTsDefinitions);
    }

    private void addGenerateServiceWorkerTask(Options options, PwaConfiguration pwaConfiguration) {
        if (pwaConfiguration.isEnabled()) {
            this.commands.add(new TaskGenerateServiceWorker(options));
        }
    }

    private void addEndpointServicesTasks(Options options) {
        Lookup lookup = options.getLookup();
        EndpointGeneratorTaskFactory endpointGeneratorTaskFactory = lookup.lookup(EndpointGeneratorTaskFactory.class);
        if (endpointGeneratorTaskFactory != null) {
            TaskGenerateOpenAPI taskGenerateOpenAPI = endpointGeneratorTaskFactory.createTaskGenerateOpenAPI(options);
            this.commands.add(taskGenerateOpenAPI);
            if (options.getFrontendGeneratedFolder() != null) {
                TaskGenerateEndpoint taskGenerateEndpoint = endpointGeneratorTaskFactory.createTaskGenerateEndpoint(options);
                this.commands.add(taskGenerateEndpoint);
            }
        }
    }

    private FrontendDependenciesScanner getFallbackScanner(Options options, ClassFinder finder, FeatureFlags featureFlags) {
        if (options.isUseByteCodeScanner()) {
            return new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(true, finder, options.isGenerateEmbeddableWebComponents(), featureFlags, true);
        }
        return null;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        this.sortCommands(this.commands);
        for (FallibleCommand command : this.commands) {
            command.execute();
        }
    }

    private void sortCommands(List<FallibleCommand> commandList) {
        commandList.sort((c1, c2) -> {
            int indexOf1 = this.getIndex((FallibleCommand)c1);
            int indexOf2 = this.getIndex((FallibleCommand)c2);
            if (indexOf1 == -1 || indexOf2 == -1) {
                return 0;
            }
            return indexOf1 - indexOf2;
        });
    }

    private int getIndex(FallibleCommand command) {
        int index = commandOrder.indexOf(command.getClass());
        if (index != -1) {
            return index;
        }
        for (int i = 0; i < commandOrder.size(); ++i) {
            if (!commandOrder.get(i).isAssignableFrom(command.getClass())) continue;
            return i;
        }
        throw new UnknownTaskException(command);
    }
}

