/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.TaskRunDevBundleBuild;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendUtils {
    public static final String PROJECT_BASEDIR = "project.basedir";
    public static final String DEFAULT_NODE_DIR = "./";
    public static final String NODE_MODULES = "node_modules/";
    public static final String FRONTEND = "frontend/";
    public static final String GENERATED = "generated/";
    public static final String DEFAULT_FRONTEND_DIR = "./frontend/";
    public static final String VITE_CONFIG = "vite.config.ts";
    public static final String VITE_GENERATED_CONFIG = "vite.generated.ts";
    public static final String SERVICE_WORKER_SRC = "sw.ts";
    public static final String SERVICE_WORKER_SRC_JS = "sw.js";
    public static final String JAR_RESOURCES_FOLDER = "jar-resources";
    public static final String JAR_RESOURCES_IMPORT = "Frontend/generated/jar-resources/";
    public static final String JAR_RESOURCES_IMPORT_FRONTEND_RELATIVE = "Frontend/generated/jar-resources/".replace("Frontend/", "./");
    public static final String DEFAULT_GENERATED_DIR = "frontend/";
    public static final String IMPORTS_NAME = "generated-flow-imports.js";
    public static final String IMPORTS_D_TS_NAME = "generated-flow-imports.d.ts";
    public static final String THEME_IMPORTS_D_TS_NAME = "theme.d.ts";
    public static final String THEME_IMPORTS_NAME = "theme.js";
    public static final String BOOTSTRAP_FILE_NAME = "vaadin.ts";
    public static final String WEB_COMPONENT_BOOTSTRAP_FILE_NAME = "vaadin-web-component.ts";
    public static final String FEATURE_FLAGS_FILE_NAME = "vaadin-featureflags.ts";
    public static final String INDEX_HTML = "index.html";
    public static final String WEB_COMPONENT_HTML = "web-component.html";
    public static final String INDEX_TS = "index.ts";
    public static final String INDEX_JS = "index.js";
    public static final String INDEX_TSX = "index.tsx";
    public static final String VITE_DEVMODE_TS = "vite-devmode.ts";
    public static final String DEFAULT_PROJECT_FRONTEND_GENERATED_DIR = "./frontend/generated/";
    public static final String FALLBACK_IMPORTS_NAME = "generated-flow-imports-fallback.js";
    public static final String PARAM_GENERATED_DIR = "vaadin.frontend.generated.folder";
    public static final String PARAM_FRONTEND_DIR = "vaadin.frontend.frontend.folder";
    public static final String PARAM_IGNORE_VERSION_CHECKS = "vaadin.ignoreVersionChecks";
    public static final String FRONTEND_FOLDER_ALIAS = "Frontend/";
    public static final String TOKEN_FILE = "config/flow-build-info.json";
    public static final String CHUNKS = "chunks";
    public static final String FALLBACK = "fallback";
    public static final String EXPORT_CHUNK = "export";
    public static final String CSS_IMPORTS = "cssImports";
    public static final String JS_MODULES = "jsModules";
    public static final String PARAM_TOKEN_FILE = "vaadin.frontend.token.file";
    public static final String DISABLE_CHECK = "%nYou can disable the version check using -D%s=true";
    private static final String TOO_OLD = "%n%n======================================================================================================%nYour installed '%s' version (%s) is too old. Supported versions are %d.%d+%nPlease install a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v18.14.1\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    static final String SYSTEM_NOPROXY_PROPERTY_KEY = "NOPROXY";
    static final String SYSTEM_HTTPS_PROXY_PROPERTY_KEY = "HTTPS_PROXY";
    static final String SYSTEM_HTTP_PROXY_PROPERTY_KEY = "HTTP_PROXY";
    public static final String YELLOW = "\u001b[38;5;111m%s\u001b[0m";
    public static final String RED = "\u001b[38;5;196m%s\u001b[0m";
    public static final String GREEN = "\u001b[38;5;35m%s\u001b[0m";
    public static final String BRIGHT_BLUE = "\u001b[94m%s\u001b[0m";
    private static final Pattern THEME_GENERATED_FILE_PATTERN = Pattern.compile("theme-([\\s\\S]+?)\\.generated\\.js");

    private FrontendUtils() {
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return FrontendUtils.getOsName().startsWith("Windows");
    }

    public static String streamToString(InputStream inputStream) {
        String string;
        block8: {
            String ret = "";
            InputStream handledStream = inputStream;
            try {
                string = IOUtils.toString((InputStream)handledStream, (Charset)StandardCharsets.UTF_8).replaceAll("\\R", System.lineSeparator());
                if (handledStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (handledStream != null) {
                        try {
                            handledStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    LoggerFactory.getLogger(FrontendUtils.class).warn("Couldn't close template input stream", (Throwable)exception);
                    return ret;
                }
            }
            handledStream.close();
        }
        return string;
    }

    public static ProcessBuilder createProcessBuilder(List<String> command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandFile = new File(command.get(0));
        if (commandFile.isAbsolute()) {
            String commandPath = commandFile.getParent();
            Map<String, String> environment = processBuilder.environment();
            String pathEnvVar = FrontendUtils.isWindows() ? environment.keySet().stream().filter("PATH"::equalsIgnoreCase).findFirst().orElse("Path") : "PATH";
            Object path = environment.get(pathEnvVar);
            path = path == null || ((String)path).isEmpty() ? commandPath : commandPath + File.pathSeparatorChar + (String)path;
            environment.put(pathEnvVar, (String)path);
        }
        return processBuilder;
    }

    public static String getIndexHtmlContent(VaadinService service) throws IOException {
        return FrontendUtils.getFileContent(service, INDEX_HTML);
    }

    public static String getWebComponentHtmlContent(VaadinService service) throws IOException {
        return FrontendUtils.getFileContent(service, WEB_COMPONENT_HTML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(VaadinService service, String path) throws IOException {
        String string;
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        InputStream content = null;
        try {
            Optional<DevModeHandler> devModeHandler = DevModeHandlerManager.getDevModeHandler(service);
            content = config.isProductionMode() ? FrontendUtils.getFileFromClassPath(service, path) : (devModeHandler.isPresent() ? FrontendUtils.getFileFromDevModeHandler(devModeHandler.get(), path) : FrontendUtils.getFileFromFrontendDir(config, path));
            string = content != null ? FrontendUtils.streamToString(content) : null;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(content);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)content);
        return string;
    }

    private static InputStream getFileFromFrontendDir(AbstractConfiguration config, String path) {
        File file = new File(new File(config.getProjectFolder(), "frontend"), path);
        if (file.exists()) {
            try {
                return Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }

    private static InputStream getFileFromClassPath(VaadinService service, String filePath) {
        URL resource = service.getContext().getAttribute(Lookup.class).lookup(ResourceProvider.class).getApplicationResource("META-INF/VAADIN/webapp/" + filePath);
        if (resource == null) {
            FrontendUtils.getLogger().error("Cannot get the '{}' from the classpath", (Object)filePath);
            return null;
        }
        try {
            return resource.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static InputStream getFileFromDevModeHandler(DevModeHandler devModeHandler, String filePath) throws IOException {
        return devModeHandler.prepareConnection("/" + filePath, "GET").getInputStream();
    }

    public static InputStream getFrontendFileFromDevModeHandler(VaadinService service, String path) {
        Optional<DevModeHandler> devModeHandler = DevModeHandlerManager.getDevModeHandler(service);
        if (devModeHandler.isPresent()) {
            try {
                File frontendFile = FrontendUtils.resolveFrontendPath(devModeHandler.get().getProjectRoot(), path);
                return frontendFile == null ? null : new FileInputStream(frontendFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading file " + path, e);
            }
        }
        return null;
    }

    public static File resolveFrontendPath(File projectRoot, String path) {
        return FrontendUtils.resolveFrontendPath(projectRoot, path, new File(projectRoot, "frontend/"));
    }

    public static File resolveFrontendPath(File projectRoot, String path, File frontendDirectory) {
        File nodeModulesFolder = new File(projectRoot, NODE_MODULES);
        File addonsFolder = FrontendUtils.getJarResourcesFolder(frontendDirectory);
        List<File> candidateParents = path.startsWith(DEFAULT_NODE_DIR) ? Arrays.asList(frontendDirectory, addonsFolder) : Arrays.asList(nodeModulesFolder, frontendDirectory, addonsFolder);
        return candidateParents.stream().map(parent -> new File((File)parent, path)).filter(File::exists).findFirst().orElse(null);
    }

    public static String getJarResourceString(String jarImport) {
        String string;
        block10: {
            ClassLoader classLoader = FrontendUtils.class.getClassLoader();
            URL resource = classLoader.getResource("META-INF/frontend/" + jarImport);
            if (resource == null) {
                resource = classLoader.getResource("META-INF/resources/frontend/" + jarImport);
            }
            if (resource == null) {
                return null;
            }
            InputStream frontendContent = resource.openStream();
            try {
                string = FrontendUtils.streamToString(frontendContent);
                if (frontendContent == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (frontendContent != null) {
                        try {
                            frontendContent.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            frontendContent.close();
        }
        return string;
    }

    public static File getJarResourcesFolder(File frontendDirectory) {
        return new File(FrontendUtils.getFrontendGeneratedFolder(frontendDirectory), JAR_RESOURCES_FOLDER);
    }

    private static File getFrontendGeneratedFolder(File frontendDirectory) {
        return new File(frontendDirectory, GENERATED);
    }

    private static String buildTooOldString(String tool, String version, int supportedMajor, int supportedMinor) {
        return String.format(TOO_OLD, tool, version, supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS);
    }

    public static String getProjectFrontendDir(DeploymentConfiguration configuration) {
        return configuration.getStringProperty(PARAM_FRONTEND_DIR, DEFAULT_FRONTEND_DIR);
    }

    public static String getUnixRelativePath(Path source, Path target) {
        return FrontendUtils.getUnixPath(source.relativize(target));
    }

    public static String getUnixPath(Path source) {
        return source.toString().replaceAll("\\\\", "/");
    }

    public static FallbackChunk readFallbackChunk(JsonObject object) {
        if (!object.hasKey(CHUNKS)) {
            return null;
        }
        JsonObject obj = object.getObject(CHUNKS);
        if (!obj.hasKey(FALLBACK)) {
            return null;
        }
        obj = obj.getObject(FALLBACK);
        ArrayList<String> fallbackModles = new ArrayList<String>();
        JsonArray modules = obj.getArray(JS_MODULES);
        for (int i = 0; i < modules.length(); ++i) {
            fallbackModles.add(modules.getString(i));
        }
        ArrayList<FallbackChunk.CssImportData> fallbackCss = new ArrayList<FallbackChunk.CssImportData>();
        JsonArray css = obj.getArray(CSS_IMPORTS);
        for (int i = 0; i < css.length(); ++i) {
            fallbackCss.add(FrontendUtils.createCssData(css.getObject(i)));
        }
        return new FallbackChunk(fallbackModles, fallbackCss);
    }

    private static FallbackChunk.CssImportData createCssData(JsonObject object) {
        String value = null;
        String id = null;
        String include = null;
        String themeFor = null;
        if (object.hasKey("value")) {
            value = object.getString("value");
        }
        if (object.hasKey("id")) {
            id = object.getString("id");
        }
        if (object.hasKey("include")) {
            include = object.getString("include");
        }
        if (object.hasKey("themeFor")) {
            themeFor = object.getString("themeFor");
        }
        return new FallbackChunk.CssImportData(value, id, include, themeFor);
    }

    static void validateToolVersion(String tool, FrontendVersion toolVersion, FrontendVersion supported) {
        if (FrontendUtils.isVersionAtLeast(toolVersion, supported)) {
            return;
        }
        throw new IllegalStateException(FrontendUtils.buildTooOldString(tool, toolVersion.getFullVersion(), supported.getMajorVersion(), supported.getMinorVersion()));
    }

    static boolean isVersionAtLeast(FrontendVersion toolVersion, FrontendVersion required) {
        int major = toolVersion.getMajorVersion();
        int minor = toolVersion.getMinorVersion();
        return major > required.getMajorVersion() || major == required.getMajorVersion() && minor >= required.getMinorVersion();
    }

    protected static FrontendVersion getVersion(String tool, List<String> versionCommand) throws UnknownVersionException {
        String output;
        try {
            output = FrontendUtils.executeCommand(versionCommand);
        }
        catch (CommandExecutionException e) {
            throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand), e);
        }
        try {
            return new FrontendVersion(FrontendUtils.parseVersionString(output));
        }
        catch (IOException e) {
            throw new UnknownVersionException(tool, "Expected a version number as output but got '" + output + "' when using command " + String.join((CharSequence)" ", versionCommand), e);
        }
    }

    public static String executeCommand(List<String> command) throws CommandExecutionException {
        try {
            Process process = FrontendUtils.createProcessBuilder(command).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new CommandExecutionException(exitCode, FrontendUtils.streamToString(process.getInputStream()), FrontendUtils.streamToString(process.getErrorStream()));
            }
            return FrontendUtils.streamToString(process.getInputStream());
        }
        catch (IOException | InterruptedException e) {
            throw new CommandExecutionException(e);
        }
    }

    public static FrontendVersion parseFrontendVersion(String versionString) throws IOException {
        return new FrontendVersion(FrontendUtils.parseVersionString(versionString));
    }

    public static File getVaadinHomeDirectory() {
        File home = FileUtils.getUserDirectory();
        if (!home.exists()) {
            throw new IllegalStateException("The user directory '" + home.getAbsolutePath() + "' doesn't exist");
        }
        if (!home.isDirectory()) {
            throw new IllegalStateException("The path '" + home.getAbsolutePath() + "' is not a directory");
        }
        File vaadinFolder = new File(home, ".vaadin");
        if (vaadinFolder.exists()) {
            if (vaadinFolder.isDirectory()) {
                return vaadinFolder;
            }
            throw new IllegalStateException("The path '" + vaadinFolder.getAbsolutePath() + "' is not a directory. This path is used to store vaadin related data. Please either remove the file or create a directory");
        }
        try {
            FileUtils.forceMkdir((File)vaadinFolder);
            return vaadinFolder;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't create '.vaadin' folder inside home directory '" + home.getAbsolutePath() + "'", exception);
        }
    }

    static String parseVersionString(String output) throws IOException {
        Optional<String> lastOuput = Stream.of(output.split("\n")).filter(line -> !line.matches("^[ ]*$")).reduce((first, second) -> second);
        return lastOuput.map(line -> line.replaceFirst("^v", "")).orElseThrow(() -> new IOException("No output"));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FrontendUtils.class);
    }

    public static String commandToString(String baseDir, List<String> command) {
        StringBuilder retval = new StringBuilder("\n");
        StringBuilder curLine = new StringBuilder();
        for (String fragment : command) {
            if (curLine.length() + fragment.length() > 55) {
                retval.append(curLine.toString());
                retval.append("\\ \n");
                curLine = new StringBuilder("    ");
            }
            curLine.append(fragment.replace(baseDir, "."));
            curLine.append(" ");
        }
        retval.append(curLine.toString());
        retval.append("\n");
        return retval.toString();
    }

    public static FrontendVersion getPackageVersionFromJson(JsonObject sourceJson, String pkg, String versionOrigin) {
        if (!sourceJson.hasKey(pkg)) {
            return null;
        }
        try {
            String versionString = sourceJson.getString(pkg);
            return new FrontendVersion(pkg, versionString);
        }
        catch (ClassCastException classCastException) {
            LoggerFactory.getLogger(FrontendVersion.class).warn("Ignoring error while parsing frontend dependency version for package '{}' in '{}'", (Object)pkg, (Object)versionOrigin);
        }
        catch (NumberFormatException nfe) {
            LoggerFactory.getLogger(FrontendVersion.class).warn("Ignoring error while parsing frontend dependency version in {}: {}", (Object)versionOrigin, (Object)nfe.getMessage());
        }
        return null;
    }

    public static void console(String format, Object message) {
        System.out.print(String.format(format, message));
    }

    public static void deleteNodeModules(File nodeModules) throws IOException {
        if (!nodeModules.exists()) {
            return;
        }
        if (!nodeModules.isDirectory() || !nodeModules.getName().equals("node_modules")) {
            throw new IOException(nodeModules.getAbsolutePath() + " does not look like a node_modules directory");
        }
        FrontendUtils.deleteDirectory(nodeModules);
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        if (!Files.isSymbolicLink(directory.toPath()) && !FrontendUtils.isJunction(directory.toPath())) {
            FrontendUtils.cleanDirectory(directory);
        }
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    private static boolean isJunction(Path directory) throws IOException {
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        BasicFileAttributes attrs = Files.readAttributes(directory, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        return isWindows && attrs.isDirectory() && attrs.isOther();
    }

    private static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                FrontendUtils.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FrontendUtils.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static String getFrontendServletPath(ServletContext servletContext) {
        String mapping = VaadinServlet.getFrontendMapping();
        if (mapping.endsWith("/*")) {
            mapping = mapping.replace("/*", "");
        }
        return mapping;
    }

    public static URL findBundleFile(File projectDir, String filename) throws IOException {
        File bundleFile;
        File devBundleFolder = FrontendUtils.getDevBundleFolder(projectDir);
        if (devBundleFolder.exists() && (bundleFile = new File(devBundleFolder, filename)).exists()) {
            return bundleFile.toURI().toURL();
        }
        return TaskRunDevBundleBuild.class.getClassLoader().getResource("vaadin-dev-bundle/" + filename);
    }

    public static File getDevBundleFolder(File projectDir) {
        return new File(projectDir, "src/main/dev-bundle");
    }

    public static String findBundleStatsJson(File projectDir) throws IOException {
        URL statsJson = FrontendUtils.findBundleFile(projectDir, "config/stats.json");
        if (statsJson == null) {
            FrontendUtils.getLogger().warn("There is no dev-bundle in the project or on the classpath nor is there a default bundle included. Verify that the dependency 'com.vaadin:vaadin-dev-bundle' is added to your project.");
            return null;
        }
        return IOUtils.toString((URL)statsJson, (Charset)StandardCharsets.UTF_8);
    }

    public static Optional<String> getThemeName(File projectFolder) throws IOException {
        File themeJs = new File(projectFolder, "frontend/generated/theme.js");
        if (!themeJs.exists()) {
            return Optional.empty();
        }
        String themeJsContent = FileUtils.readFileToString((File)themeJs, (Charset)StandardCharsets.UTF_8);
        Matcher matcher = THEME_GENERATED_FILE_PATTERN.matcher(themeJsContent);
        if (matcher.find()) {
            return Optional.of(matcher.group(1));
        }
        throw new IllegalStateException("Couldn't extract theme name from theme imports file 'theme.js'");
    }

    public static class CommandExecutionException
    extends Exception {
        public CommandExecutionException(int processExitCode) {
            super("Process execution failed with exit code " + processExitCode);
        }

        public CommandExecutionException(int processExitCode, String output, String errorOutput) {
            super("Process execution failed with exit code " + processExitCode + "\nOutput: " + output + "\nError output: " + errorOutput);
        }

        public CommandExecutionException(Throwable cause) {
            super("Process execution failed", cause);
        }
    }

    public static class UnknownVersionException
    extends Exception {
        public UnknownVersionException(String tool, String extraInfo) {
            super("Unable to detect version of " + tool + ". " + extraInfo);
        }

        public UnknownVersionException(String tool, String extraInfo, Exception cause) {
            super("Unable to detect version of " + tool + ". " + extraInfo, cause);
        }
    }
}

