/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.communication.UidlWriter;
import elemental.json.JsonObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterAdapter;
import org.atmosphere.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmospherePushConnection
implements PushConnection {
    private UI ui;
    private transient State state = State.DISCONNECTED;
    private transient AtmosphereResource resource;
    private transient FragmentedMessage incomingMessage;
    private transient Future<Object> outgoingMessage;
    private transient Object lock = new Object();
    private volatile boolean disconnecting;

    public AtmospherePushConnection(UI ui) {
        this.ui = ui;
        UsageStatistics.markAsUsed("flow/AtmospherePushConnection", AtmospherePushConnection.getAtmosphereVersion());
    }

    public static String getAtmosphereVersion() {
        try {
            String v = Version.getRawVersion();
            assert (v != null);
            return v;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    @Override
    public void push() {
        this.push(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(boolean async) {
        if (this.disconnecting || !this.isConnected()) {
            if (this.disconnecting) {
                AtmospherePushConnection.getLogger().debug("Disconnection in progress, ignoring push request");
            }
            this.state = async && this.state != State.RESPONSE_PENDING ? State.PUSH_PENDING : State.RESPONSE_PENDING;
        } else {
            Object object = this.lock;
            synchronized (object) {
                try {
                    JsonObject response = new UidlWriter().createUidl(this.getUI(), async);
                    this.sendMessage("for(;;);[" + response.toJson() + "]");
                }
                catch (Exception e) {
                    throw new RuntimeException("Push failed", e);
                }
            }
        }
    }

    protected void sendMessage(String message) {
        assert (this.isConnected());
        this.outgoingMessage = this.getResource().getBroadcaster().broadcast((Object)new PushMessage(this.ui.getInternals().getServerSyncId() - 1, message), this.getResource());
    }

    protected Reader receiveMessage(Reader reader) throws IOException {
        if (this.resource == null || this.resource.transport() != AtmosphereResource.TRANSPORT.WEBSOCKET) {
            return reader;
        }
        if (this.incomingMessage == null) {
            this.incomingMessage = new FragmentedMessage(reader);
        }
        if (this.incomingMessage.append(reader)) {
            Reader completeReader = this.incomingMessage.getReader();
            this.incomingMessage = null;
            return completeReader;
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        assert (this.state != null);
        assert (this.state == State.CONNECTED ^ this.resource == null);
        return this.state == State.CONNECTED;
    }

    public void connect(AtmosphereResource resource) {
        assert (resource != null);
        assert (resource != this.resource);
        if (this.isConnected()) {
            this.disconnect();
        }
        this.resource = resource;
        State oldState = this.state;
        this.state = State.CONNECTED;
        if (oldState == State.PUSH_PENDING || oldState == State.RESPONSE_PENDING) {
            this.push(oldState == State.PUSH_PENDING);
        }
    }

    protected UI getUI() {
        return this.ui;
    }

    protected AtmosphereResource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this.disconnecting) {
            AtmospherePushConnection.getLogger().debug("Disconnection already in progress, ignoring request");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isConnected() || this.resource == null) {
                AtmospherePushConnection.getLogger().debug("Disconnection already happened, ignoring request");
                return;
            }
            try {
                this.disconnecting = true;
                if (this.resource.isResumed()) {
                    this.connectionLost();
                    return;
                }
                if (this.outgoingMessage != null) {
                    try {
                        this.outgoingMessage.get(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        if (this.ui.isClosing()) {
                            AtmospherePushConnection.getLogger().debug("Something was not sent to client on an UI that was already closed by beacon request or similar. This seems to happen with Safari occassionally when navigating away from a UI.");
                        } else {
                            AtmospherePushConnection.getLogger().info("Timeout waiting for messages to be sent to client before disconnect", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        AtmospherePushConnection.getLogger().info("Error waiting for messages to be sent to client before disconnect", (Throwable)e);
                    }
                    this.outgoingMessage = null;
                }
                try {
                    this.resource.close();
                }
                catch (IOException e) {
                    AtmospherePushConnection.getLogger().info("Error when closing push connection", (Throwable)e);
                }
                this.connectionLost();
            }
            finally {
                this.disconnecting = false;
            }
        }
    }

    public void connectionLost() {
        this.resource = null;
        if (this.state == State.CONNECTED) {
            this.state = State.DISCONNECTED;
        }
    }

    protected State getState() {
        return this.state;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.state = State.DISCONNECTED;
        this.disconnecting = false;
        this.lock = new Object();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)AtmospherePushConnection.class.getName());
    }

    public static void enableAtmosphereDebugLogging() {
        AtmospherePushConnection.getLogger().warn("Enable logging of 'org.atmosphere' through your slf4j implementation instead (i.e.: logback, log4j, etc)");
    }

    static final class PushMessageUnwrapFilter
    extends BroadcastFilterAdapter
    implements Serializable {
        PushMessageUnwrapFilter() {
        }

        public BroadcastFilter.BroadcastAction filter(String broadcasterId, AtmosphereResource r, Object originalMessage, Object message) {
            if (message instanceof PushMessage) {
                message = ((PushMessage)message).message;
            }
            return new BroadcastFilter.BroadcastAction(message);
        }
    }

    static final class PushMessage
    implements Serializable {
        final int serverSyncId;
        final String message;

        PushMessage(int serverSyncId, String message) {
            this.serverSyncId = serverSyncId;
            this.message = message;
        }

        boolean alreadySeen(int lastSeenOnClient) {
            return this.serverSyncId <= lastSeenOnClient;
        }
    }

    protected static enum State {
        DISCONNECTED,
        PUSH_PENDING,
        RESPONSE_PENDING,
        CONNECTED;

    }

    protected static class FragmentedMessage
    implements Serializable {
        private final StringBuilder message = new StringBuilder();
        private final int messageLength;

        public FragmentedMessage(Reader reader) throws IOException {
            int c;
            Object length = "";
            while ((c = reader.read()) != -1 && c != 124) {
                length = (String)length + (char)c;
            }
            try {
                this.messageLength = Integer.parseInt((String)length);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid message length " + (String)length, e);
            }
        }

        public boolean append(Reader reader) throws IOException {
            int read;
            char[] buffer = new char[16384];
            while ((read = reader.read(buffer)) != -1) {
                this.message.append(buffer, 0, read);
                assert (this.message.length() <= this.messageLength) : "Received message " + this.message.length() + "chars, expected " + this.messageLength;
            }
            return this.message.length() == this.messageLength;
        }

        public Reader getReader() {
            return new StringReader(this.message.toString());
        }
    }
}

