/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.AbstractListChange;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.change.ListClearChange;
import com.vaadin.flow.internal.change.ListRemoveChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class NodeList<T extends Serializable>
extends NodeFeature {
    private List<T> values;
    private boolean isRemoveAllCalled;
    private boolean isPopulated;

    protected NodeList(StateNode node) {
        super(node);
        this.isPopulated = !node.isReportedFeature(this.getClass());
    }

    protected int size() {
        this.setAccessed();
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    private void ensureValues() {
        if (this.values == null) {
            this.values = new ArrayList<T>(1);
        }
    }

    protected T get(int index) {
        this.setAccessed();
        if (this.values == null) {
            throw new IndexOutOfBoundsException();
        }
        return (T)((Serializable)this.values.get(index));
    }

    protected void add(T item) {
        this.ensureValues();
        this.add(this.values.size(), item);
    }

    protected void addAll(Collection<? extends T> items) {
        assert (items != null);
        if (items.isEmpty()) {
            return;
        }
        ArrayList<? extends T> itemsList = new ArrayList<T>(items);
        this.ensureValues();
        int startIndex = this.values.size();
        this.values.addAll(itemsList);
        this.addChange(new ListAddChange<T>(this, this.isNodeValues(), startIndex, itemsList));
    }

    protected void add(int index, T item) {
        this.ensureValues();
        this.values.add(index, item);
        this.addChange(new ListAddChange<T>(this, this.isNodeValues(), index, Collections.singletonList(item)));
    }

    protected T remove(int index) {
        if (this.values == null) {
            throw new IndexOutOfBoundsException();
        }
        Serializable removed = (Serializable)this.values.remove(index);
        this.addChange(new ListRemoveChange<Serializable>(this, index, removed));
        if (this.values.isEmpty()) {
            this.values = null;
        }
        return (T)removed;
    }

    protected List<AbstractListChange<T>> getChangeTracker() {
        return this.getNode().getChangeTracker(this, ArrayList::new);
    }

    private void addChange(AbstractListChange<T> change) {
        this.getNode().markAsDirty();
        this.getChangeTracker().add(change);
    }

    private void setAccessed() {
    }

    @Override
    public void collectChanges(Consumer<NodeChange> collector) {
        IdentityHashMap<Object, Integer> indices = new IdentityHashMap<Object, Integer>();
        ArrayList<AbstractListChange<T>> allChanges = new ArrayList<AbstractListChange<T>>();
        int index = 0;
        for (AbstractListChange<T> change : this.getChangeTracker()) {
            if (change instanceof ListRemoveChange) {
                this.adjustChanges(index, (ListRemoveChange)change, indices, allChanges);
            } else if (change instanceof ListAddChange) {
                allChanges.add(change);
                int i = index;
                ((ListAddChange)change).getNewItems().forEach(item -> indices.put(item, i));
            } else if (change instanceof ListClearChange) {
                allChanges.clear();
                indices.clear();
                index = 0;
                allChanges.add(change);
            } else assert (false) : "AbstractListChange has only three subtypes: add, remove and clear";
            ++index;
        }
        List<NodeChange> changes = allChanges.stream().filter(this::acceptChange).collect(Collectors.toList());
        if (this.isPopulated) {
            changes.forEach(collector);
        } else {
            if (changes.isEmpty()) {
                collector.accept(new EmptyChange(this));
            } else {
                changes.forEach(collector);
            }
            this.isPopulated = true;
        }
    }

    private boolean acceptChange(AbstractListChange<T> change) {
        if (change == null) {
            return false;
        }
        if (change instanceof ListAddChange) {
            return !((ListAddChange)change).isEmpty();
        }
        return true;
    }

    @Override
    public void forEachChild(Consumer<StateNode> action) {
    }

    @Override
    public void generateChangesFromEmpty() {
        if (this.isRemoveAllCalled) {
            this.addChange(new ListClearChange(this));
        }
        if (this.values != null) {
            assert (!this.values.isEmpty());
            this.getChangeTracker().add(new ListAddChange<T>(this, this.isNodeValues(), 0, new ArrayList<T>(this.values)));
        } else if (!this.isPopulated) {
            this.getChangeTracker();
        }
    }

    protected boolean isNodeValues() {
        return false;
    }

    protected void clear() {
        if (this.values != null) {
            this.values.clear();
            this.values = null;
        }
        this.isRemoveAllCalled = true;
        this.addChange(new ListClearChange(this));
    }

    protected int indexOf(T value) {
        this.setAccessed();
        if (this.values == null) {
            return -1;
        }
        return this.values.indexOf(value);
    }

    protected Iterator<T> iterator() {
        if (this.values == null) {
            return Collections.emptyList().iterator();
        }
        return new NodeListIterator();
    }

    private void adjustChanges(int removeChangeIndex, ListRemoveChange<T> change, Map<Object, Integer> indices, List<AbstractListChange<T>> allChanges) {
        Object removedItem = change.getRemovedItem();
        Integer addChangeIndex = indices.get(removedItem);
        if (addChangeIndex == null) {
            allChanges.add(change);
        } else {
            AbstractListChange<T> addChange = allChanges.get(addChangeIndex);
            assert (addChange instanceof ListAddChange);
            ListAddChange add = (ListAddChange)addChange;
            int indexToCorrect = add.getNewItems().indexOf(removedItem);
            assert (indexToCorrect != -1);
            indexToCorrect += add.getIndex();
            allChanges.set(addChangeIndex, add.copy(add.getNewItems().stream().filter(item -> item != removedItem).collect(Collectors.toList())));
            for (int i = addChangeIndex + 1; i < removeChangeIndex; ++i) {
                AbstractListChange<T> listChange = allChanges.get(i);
                if (listChange == null || listChange.getIndex() <= indexToCorrect) continue;
                allChanges.set(i, listChange.copy(listChange.getIndex() - 1));
            }
            allChanges.add(null);
        }
    }

    @Override
    public void onDetach() {
        if (this.isPopulated && this.values == null) {
            this.isPopulated = false;
        }
    }

    protected static abstract class SetView<T extends Serializable>
    extends AbstractSet<T>
    implements Serializable {
        private NodeList<T> nodeList;

        public SetView(NodeList<T> nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public int size() {
            return this.nodeList.size();
        }

        @Override
        public void clear() {
            this.nodeList.clear();
        }

        @Override
        public boolean add(T o) {
            this.validate(o);
            if (this.contains(o)) {
                return false;
            }
            this.nodeList.add(this.size(), o);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return super.remove(o);
        }

        protected abstract void validate(T var1);

        @Override
        public boolean contains(Object o) {
            return this.nodeList.indexOf((Serializable)o) != -1;
        }

        @Override
        public Iterator<T> iterator() {
            return this.nodeList.iterator();
        }
    }

    private final class NodeListIterator
    implements Iterator<T> {
        private int index = -1;
        private T current;
        private Iterator<T> arrayIterator;

        private NodeListIterator() {
            this.arrayIterator = NodeList.this.values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext();
        }

        @Override
        public T next() {
            ++this.index;
            this.current = (Serializable)this.arrayIterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.arrayIterator.remove();
            NodeList.this.addChange(new ListRemoveChange(NodeList.this, this.index, this.current));
            --this.index;
        }
    }
}

