/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.annotation.HandlesTypes;

public abstract class AbstractAnnotationValidator
implements Serializable {
    public static final String ERROR_MESSAGE_BEGINNING = "Found configuration annotations that will not be used in the application. \nMove the following annotations to a single route or the top RouterLayout of the application: \n";
    public static final String NON_PARENT = "Non parent Route target: %s contains: %s";
    public static final String NON_PARENT_ALIAS = "Non parent RouteAlias target: %s contains: %s";
    public static final String NON_ROUTER_LAYOUT = "Non RouterLayout: %s contains: %s";
    public static final String MIDDLE_ROUTER_LAYOUT = "Middle layout: %s contains: %s";

    protected void validateClasses(Collection<Class<?>> classSet) {
        if (classSet == null) {
            return;
        }
        List<String> offendingAnnotations = this.validateAnnotatedClasses(classSet);
        if (!offendingAnnotations.isEmpty()) {
            String message = this.getErrorHint() + String.join((CharSequence)"\n", offendingAnnotations);
            throw new InvalidApplicationConfigurationException(message);
        }
    }

    protected abstract List<Class<?>> getAnnotations();

    protected Optional<String> handleNonRouterLayout(Class<?> clazz) {
        return Optional.of(String.format(NON_ROUTER_LAYOUT, clazz.getName(), this.getClassAnnotations(clazz)));
    }

    protected String getErrorHint() {
        return ERROR_MESSAGE_BEGINNING;
    }

    protected String getClassAnnotations(Class<?> clazz) {
        return AbstractAnnotationValidator.getClassAnnotations(clazz, this.getAnnotations());
    }

    public static String getClassAnnotations(Class<?> clazz, List<Class<?>> annotations) {
        return annotations.stream().filter(ann -> clazz.isAnnotationPresent((Class<Annotation>)ann)).map(ann -> "@" + ann.getName().replaceFirst("^.*\\.([^$\\.]+).*$", "$1")).collect(Collectors.joining(", "));
    }

    private List<String> validateAnnotatedClasses(Collection<Class<?>> classSet) {
        ArrayList<String> offendingAnnotations = new ArrayList<String>();
        for (Class<?> clazz : classSet) {
            Route route = clazz.getAnnotation(Route.class);
            if (route != null) {
                RouteAlias routeAlias;
                if (!UI.class.equals(route.layout())) {
                    offendingAnnotations.add(String.format(NON_PARENT, clazz.getName(), this.getClassAnnotations(clazz)));
                }
                if ((routeAlias = clazz.getAnnotation(RouteAlias.class)) == null || UI.class.equals(routeAlias.layout())) continue;
                offendingAnnotations.add(String.format(NON_PARENT_ALIAS, clazz.getName(), this.getClassAnnotations(clazz)));
                continue;
            }
            if (AppShellConfigurator.class.isAssignableFrom(clazz)) continue;
            if (!RouterLayout.class.isAssignableFrom(clazz)) {
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                this.handleNonRouterLayout(clazz).ifPresent(offendingAnnotations::add);
                continue;
            }
            if (!RouterLayout.class.isAssignableFrom(clazz) || clazz.getAnnotation(ParentLayout.class) == null) continue;
            offendingAnnotations.add(String.format(MIDDLE_ROUTER_LAYOUT, clazz.getName(), this.getClassAnnotations(clazz)));
        }
        return offendingAnnotations;
    }

    public static Set<Class<?>> removeHandleTypesSelfReferences(Set<Class<?>> classSet, Object handlesTypesAnnotated) {
        if (classSet == null) {
            return new HashSet();
        }
        Optional<HandlesTypes> handlesTypesAnnotation = AnnotationReader.getAnnotationFor(handlesTypesAnnotated.getClass(), HandlesTypes.class);
        if (!handlesTypesAnnotation.isPresent()) {
            throw new IllegalArgumentException("Neither class " + handlesTypesAnnotated.getClass() + " nor its parents have a @" + HandlesTypes.class.getSimpleName() + " annotation");
        }
        HashSet handlesTypesInterfaces = new HashSet();
        Collections.addAll(handlesTypesInterfaces, handlesTypesAnnotation.get().value());
        return classSet.stream().filter(cls -> !handlesTypesInterfaces.contains(cls)).collect(Collectors.toSet());
    }
}

