/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.internal.UrlUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryParameters
implements Serializable {
    private static final String PARAMETER_VALUES_SEPARATOR = "=";
    private static final String PARAMETERS_SEPARATOR = "&";
    private final Map<String, List<String>> parameters;

    public QueryParameters(Map<String, List<String>> parameters) {
        this.parameters = Collections.unmodifiableMap(parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())))));
    }

    public static QueryParameters empty() {
        return new QueryParameters(Collections.emptyMap());
    }

    public static QueryParameters full(Map<String, String[]> parameters) {
        return new QueryParameters(QueryParameters.convertArraysToLists(parameters));
    }

    private static Map<String, List<String>> convertArraysToLists(Map<String, String[]> fullParameters) {
        return fullParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.asList((String[])entry.getValue())));
    }

    public static QueryParameters simple(Map<String, String> parameters) {
        return new QueryParameters(QueryParameters.toFullParameters(parameters));
    }

    private static Map<String, List<String>> toFullParameters(Map<String, String> simpleParameters) {
        return simpleParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList((String)entry.getValue())));
    }

    public static QueryParameters fromString(String queryString) {
        return new QueryParameters(QueryParameters.parseQueryString(queryString));
    }

    private static Map<String, List<String>> parseQueryString(String query) {
        Map<String, List<String>> parsedParams = Arrays.stream(query.split(PARAMETERS_SEPARATOR)).map(QueryParameters::makeQueryParamList).collect(Collectors.toMap(list -> (String)list.get(0), QueryParameters::getParameterValues, QueryParameters::mergeLists));
        return parsedParams;
    }

    private static List<String> makeQueryParamList(String paramAndValue) {
        int index = paramAndValue.indexOf(61);
        if (index == -1) {
            return Collections.singletonList(QueryParameters.decode(paramAndValue));
        }
        String param = paramAndValue.substring(0, index);
        String value = paramAndValue.substring(index + 1);
        return Arrays.asList(QueryParameters.decode(param), QueryParameters.decode(value));
    }

    private static List<String> getParameterValues(List<String> paramAndValue) {
        if (paramAndValue.size() == 1) {
            return Collections.singletonList("");
        }
        return Collections.singletonList(paramAndValue.get(1));
    }

    private static List<String> mergeLists(List<String> list1, List<String> list2) {
        ArrayList<String> result = new ArrayList<String>(list1);
        if (result.isEmpty()) {
            result.add(null);
        }
        if (list2.isEmpty()) {
            result.add(null);
        } else {
            result.addAll(list2);
        }
        return result;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public String getQueryString() {
        return this.parameters.entrySet().stream().flatMap(this::getParameterAndValues).collect(Collectors.joining(PARAMETERS_SEPARATOR));
    }

    private Stream<String> getParameterAndValues(Map.Entry<String, List<String>> entry) {
        String param = entry.getKey();
        List<String> values = entry.getValue();
        if (values.size() == 1 && "".equals(values.get(0))) {
            return Stream.of(UrlUtil.encodeURIComponent(entry.getKey()));
        }
        return values.stream().map(value -> "".equals(value) ? UrlUtil.encodeURIComponent(param) : UrlUtil.encodeURIComponent(param) + PARAMETER_VALUES_SEPARATOR + UrlUtil.encodeURIComponent(value));
    }

    private static String decode(String parameter) {
        try {
            return URLDecoder.decode(parameter, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to decode parameter: " + parameter, e);
        }
    }
}

