/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.server.communication.rpc.RpcInvocationHandler;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class NavigationRpcHandler
implements RpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "navigation";
    }

    @Override
    public Optional<Runnable> handle(UI ui, JsonObject invocationJson) {
        History history = ui.getPage().getHistory();
        History.HistoryStateChangeHandler historyStateChangeHandler = history.getHistoryStateChangeHandler();
        if (historyStateChangeHandler != null) {
            NavigationTrigger trigger;
            JsonValue state = invocationJson.get("state");
            String location = invocationJson.getString("location");
            boolean triggeredByLink = invocationJson.hasKey("link");
            NavigationTrigger navigationTrigger = trigger = triggeredByLink ? NavigationTrigger.ROUTER_LINK : NavigationTrigger.HISTORY;
            if (trigger == NavigationTrigger.ROUTER_LINK && ui.getElement().getNode().isInert()) {
                LoggerFactory.getLogger((String)NavigationRpcHandler.class.getName()).trace("Ignored router link click for location '{}' because the UI is inert.", (Object)location);
                return Optional.empty();
            }
            History.HistoryStateChangeEvent event = new History.HistoryStateChangeEvent(history, state, new Location(location), trigger);
            historyStateChangeHandler.onHistoryStateChange(event);
        }
        return Optional.empty();
    }
}

