/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.ServerSideFeature;
import com.vaadin.flow.shared.util.UniqueSerializable;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.Consumer;

public class InertData
extends ServerSideFeature {
    private static final UniqueSerializable NULL_MARKER = new UniqueSerializable(){};
    private boolean ignoreParentInert;
    private boolean inertSelf;
    private Boolean cachedInert;

    public InertData(StateNode node) {
        super(node);
    }

    public void setIgnoreParentInert(boolean ignoreParentInert) {
        if (this.ignoreParentInert != ignoreParentInert) {
            this.ignoreParentInert = ignoreParentInert;
            this.markAsDirty();
        }
    }

    public void setInertSelf(boolean inertSelf) {
        if (this.inertSelf != inertSelf) {
            this.inertSelf = inertSelf;
            this.markAsDirty();
        }
    }

    public boolean isInertSelf() {
        return this.inertSelf;
    }

    public boolean isIgnoreParentInert() {
        return this.ignoreParentInert;
    }

    @Override
    public void generateChangesFromEmpty() {
        this.updateInertAndCascadeToChildren(null);
    }

    @Override
    public void collectChanges(Consumer<NodeChange> collector) {
        this.updateInertAndCascadeToChildren(null);
    }

    private void markAsDirty() {
        this.getNode().markAsDirty();
        this.getNode().getChangeTracker(this, () -> NULL_MARKER);
    }

    public boolean isInert() {
        if (this.cachedInert == null) {
            StateNode parent = this.getNode().getParent();
            return parent != null && parent.isInert();
        }
        return this.cachedInert;
    }

    private void updateInertAndCascadeToChildren(Boolean resolvedParentInert) {
        boolean newInert = this.resolveInert(resolvedParentInert);
        if (this.cachedInert != null && this.cachedInert == newInert) {
            return;
        }
        ArrayDeque stack = new ArrayDeque();
        this.getNode().forEachChild(stack::add);
        while (!stack.isEmpty()) {
            StateNode node = (StateNode)stack.pop();
            if (node.hasFeature(InertData.class)) {
                Optional<InertData> featureIfInitialized = node.getFeatureIfInitialized(InertData.class);
                if (featureIfInitialized.isPresent()) {
                    featureIfInitialized.get().updateInertAndCascadeToChildren(newInert);
                    continue;
                }
                node.forEachChild(stack::push);
                continue;
            }
            node.forEachChild(stack::push);
        }
        this.cachedInert = newInert;
    }

    private boolean resolveInert(Boolean resolvedParentInert) {
        StateNode parent = this.getNode().getParent();
        if (this.inertSelf || this.ignoreParentInert || parent == null) {
            return this.inertSelf;
        }
        if (resolvedParentInert != null) {
            return resolvedParentInert;
        }
        do {
            Optional<InertData> optionalInertData;
            if (!(optionalInertData = parent.getFeatureIfInitialized(InertData.class)).isPresent()) continue;
            return optionalInertData.get().resolveInert(null);
        } while ((parent = parent.getParent()) != null);
        return false;
    }
}

