/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.WebpackConnectionException;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendUtils {
    public static final String PROJECT_BASEDIR = "project.basedir";
    public static final String DEFAULT_NODE_DIR = "./";
    public static final String NODE_MODULES = "node_modules/";
    public static final String FRONTEND = "frontend/";
    public static final String GENERATED = "generated/";
    public static final String DEFAULT_FRONTEND_DIR = "./frontend/";
    public static final String WEBPACK_CONFIG = "webpack.config.js";
    public static final String VITE_CONFIG = "vite.config.ts";
    public static final String VITE_GENERATED_CONFIG = "vite.generated.ts";
    public static final String WEBPACK_GENERATED = "webpack.generated.js";
    public static final String SERVICE_WORKER_SRC = "sw.ts";
    public static final String SERVICE_WORKER_SRC_JS = "sw.js";
    public static final String FLOW_NPM_PACKAGE_NAME = "@vaadin/flow-frontend/";
    public static final String DEFAULT_FLOW_RESOURCES_FOLDER = "flow-frontend";
    @Deprecated
    public static final String DEAULT_FLOW_RESOURCES_FOLDER = "flow-frontend";
    public static final String DEFAULT_GENERATED_DIR = "frontend/";
    public static final String IMPORTS_NAME = "generated-flow-imports.js";
    public static final String IMPORTS_D_TS_NAME = "generated-flow-imports.d.ts";
    public static final String THEME_IMPORTS_D_TS_NAME = "theme.d.ts";
    public static final String THEME_IMPORTS_NAME = "theme.js";
    public static final String BOOTSTRAP_FILE_NAME = "vaadin.ts";
    public static final String FEATURE_FLAGS_FILE_NAME = "vaadin-featureflags.ts";
    public static final String INDEX_HTML = "index.html";
    public static final String INDEX_TS = "index.ts";
    public static final String INDEX_JS = "index.js";
    public static final String VITE_DEVMODE_TS = "vite-devmode.ts";
    public static final String DEFAULT_CONNECT_JAVA_SOURCE_FOLDER = "src/main/java";
    public static final String DEFAULT_CONNECT_APPLICATION_PROPERTIES = "src/main/resources/application.properties";
    public static final String DEFAULT_CONNECT_OPENAPI_JSON_FILE = "generated-resources/openapi.json";
    public static final String DEFAULT_PROJECT_FRONTEND_GENERATED_DIR = "./frontend/generated/";
    public static final String FALLBACK_IMPORTS_NAME = "generated-flow-imports-fallback.js";
    public static final String PARAM_GENERATED_DIR = "vaadin.frontend.generated.folder";
    public static final String PARAM_FRONTEND_DIR = "vaadin.frontend.frontend.folder";
    public static final String PARAM_IGNORE_VERSION_CHECKS = "vaadin.ignoreVersionChecks";
    public static final String WEBPACK_PREFIX_ALIAS = "Frontend/";
    public static final String TOKEN_FILE = "config/flow-build-info.json";
    public static final String CHUNKS = "chunks";
    public static final String FALLBACK = "fallback";
    public static final String EXPORT_CHUNK = "export";
    public static final String CSS_IMPORTS = "cssImports";
    public static final String JS_MODULES = "jsModules";
    public static final String PARAM_TOKEN_FILE = "vaadin.frontend.token.file";
    public static final String DISABLE_CHECK = "%nYou can disable the version check using -D%s=true";
    private static final String NO_CONNECTION = "Webpack-dev-server couldn't be reached for %s.%nCheck the startup logs for exceptions in running webpack-dev-server.%nIf server should be running in production mode check that production mode flag is set correctly.";
    private static final String TOO_OLD = "%n%n======================================================================================================%nYour installed '%s' version (%s) is too old. Supported versions are %d.%d+%nPlease install a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v16.14.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    static final String SYSTEM_NOPROXY_PROPERTY_KEY = "NOPROXY";
    static final String SYSTEM_HTTPS_PROXY_PROPERTY_KEY = "HTTPS_PROXY";
    static final String SYSTEM_HTTP_PROXY_PROPERTY_KEY = "HTTP_PROXY";
    public static final String YELLOW = "\u001b[38;5;111m%s\u001b[0m";
    public static final String RED = "\u001b[38;5;196m%s\u001b[0m";
    public static final String GREEN = "\u001b[38;5;35m%s\u001b[0m";
    public static final String BRIGHT_BLUE = "\u001b[94m%s\u001b[0m";

    private FrontendUtils() {
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return FrontendUtils.getOsName().startsWith("Windows");
    }

    public static String streamToString(InputStream inputStream) {
        String string;
        block8: {
            String ret = "";
            InputStream handledStream = inputStream;
            try {
                string = IOUtils.toString((InputStream)handledStream, (Charset)StandardCharsets.UTF_8).replaceAll("\\R", System.lineSeparator());
                if (handledStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (handledStream != null) {
                        try {
                            handledStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    LoggerFactory.getLogger(FrontendUtils.class).warn("Couldn't close template input stream", (Throwable)exception);
                    return ret;
                }
            }
            handledStream.close();
        }
        return string;
    }

    public static ProcessBuilder createProcessBuilder(List<String> command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandFile = new File(command.get(0));
        if (commandFile.isAbsolute()) {
            String pathEnvVar;
            String commandPath = commandFile.getParent();
            Map<String, String> environment = processBuilder.environment();
            String path = environment.get(pathEnvVar = FrontendUtils.isWindows() ? environment.keySet().stream().filter("PATH"::equalsIgnoreCase).findFirst().orElse("Path") : "PATH");
            if (path == null || path.isEmpty()) {
                path = commandPath;
            } else if (!path.contains(commandPath)) {
                path = path + File.pathSeparatorChar + commandPath;
            }
            environment.put(pathEnvVar, path);
        }
        return processBuilder;
    }

    public static void clearCachedStatsContent(VaadinService service) {
        service.getContext().removeAttribute(Stats.class);
    }

    public static String getIndexHtmlContent(VaadinService service) throws IOException {
        return FrontendUtils.getFileContent(service, INDEX_HTML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(VaadinService service, String path) throws IOException {
        String string;
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        InputStream content = null;
        try {
            Optional<DevModeHandler> devModeHandler = DevModeHandlerManager.getDevModeHandler(service);
            if (!config.isProductionMode() && config.enableDevServer() && devModeHandler.isPresent()) {
                content = FrontendUtils.getFileFromDevModeHandler(devModeHandler.get(), path);
            }
            if (content == null) {
                content = FrontendUtils.getFileFromClassPath(service, path);
            }
            string = content != null ? FrontendUtils.streamToString(content) : null;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(content);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)content);
        return string;
    }

    private static InputStream getFileFromClassPath(VaadinService service, String filePath) {
        URL resource = service.getContext().getAttribute(Lookup.class).lookup(ResourceProvider.class).getApplicationResource("META-INF/VAADIN/webapp/" + filePath);
        if (resource == null) {
            FrontendUtils.getLogger().error("Cannot get the '{}' from the classpath", (Object)filePath);
            return null;
        }
        try {
            return resource.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static InputStream getResourceFromWebpack(DevModeHandler devModeHandler, String resource, String exceptionMessage) throws IOException {
        HttpURLConnection statsConnection = devModeHandler.prepareConnection(resource, "GET");
        if (statsConnection.getResponseCode() != 200) {
            throw new WebpackConnectionException(String.format(NO_CONNECTION, exceptionMessage));
        }
        return statsConnection.getInputStream();
    }

    private static InputStream getStatsFromExternalUrl(String externalStatsUrl, VaadinContext context) {
        String url;
        if (externalStatsUrl.startsWith("/")) {
            VaadinRequest request = VaadinRequest.getCurrent();
            url = FrontendUtils.getHostString(request) + externalStatsUrl;
        } else {
            url = externalStatsUrl;
        }
        try {
            URL uri = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(60000);
            connection.setConnectTimeout(60000);
            String lastModified = connection.getHeaderField("last-modified");
            if (lastModified != null) {
                LocalDateTime modified = ZonedDateTime.parse(lastModified, DateTimeFormatter.RFC_1123_DATE_TIME).toLocalDateTime();
                Stats statistics = context.getAttribute(Stats.class);
                if (statistics == null || modified.isAfter(statistics.getLastModified().orElse(LocalDateTime.MIN))) {
                    byte[] buffer = IOUtils.toByteArray((InputStream)connection.getInputStream());
                    statistics = new Stats(buffer, lastModified);
                    context.setAttribute(statistics);
                }
                return new ByteArrayInputStream(statistics.statsJson);
            }
            return connection.getInputStream();
        }
        catch (IOException e) {
            FrontendUtils.getLogger().error("Failed to retrieve stats.json from the url {}.", (Object)url, (Object)e);
            return null;
        }
    }

    private static String getHostString(VaadinRequest request) {
        String host = request.getHeader("host");
        if (host == null) {
            host = "http://127.0.0.1:8080";
        } else if (!host.contains("://")) {
            String scheme = request.getHeader("scheme");
            if (scheme == null) {
                scheme = "http";
            }
            host = scheme + "://" + host;
        }
        return host;
    }

    private static InputStream getStatsFromClassPath(VaadinService service) {
        Stats statistics = service.getContext().getAttribute(Stats.class);
        if (statistics != null) {
            return new ByteArrayInputStream(statistics.statsJson);
        }
        String stats = service.getDeploymentConfiguration().getStringProperty("statistics.file.path", "META-INF/VAADIN/config/stats.json").replaceFirst("^/", "");
        ResourceProvider resourceProvider = service.getContext().getAttribute(Lookup.class).lookup(ResourceProvider.class);
        URL statsUrl = resourceProvider.getApplicationResource(stats);
        ByteArrayInputStream stream = null;
        if (statsUrl != null) {
            try (InputStream statsStream = statsUrl.openStream();){
                byte[] buffer = IOUtils.toByteArray((InputStream)statsStream);
                statistics = new Stats(buffer, null);
                service.getContext().setAttribute(statistics);
                stream = new ByteArrayInputStream(buffer);
            }
            catch (IOException exception) {
                FrontendUtils.getLogger().warn("Couldn't read content of stats file {}", (Object)stats, (Object)exception);
                stream = null;
            }
        }
        if (stream == null) {
            FrontendUtils.getLogger().error("Cannot get the 'stats.json' from the classpath '{}'", (Object)stats);
        }
        return stream;
    }

    private static InputStream getFileFromDevModeHandler(DevModeHandler devModeHandler, String filePath) throws IOException {
        return devModeHandler.prepareConnection("/" + filePath, "GET").getInputStream();
    }

    public static InputStream getFrontendFileFromDevModeHandler(VaadinService service, String path) {
        Optional<DevModeHandler> devModeHandler = DevModeHandlerManager.getDevModeHandler(service);
        if (devModeHandler.isPresent()) {
            try {
                File frontendFile = FrontendUtils.resolveFrontendPath(devModeHandler.get().getProjectRoot(), path);
                return frontendFile == null ? null : new FileInputStream(frontendFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading file " + path, e);
            }
        }
        return null;
    }

    public static File resolveFrontendPath(File projectRoot, String path) {
        File localFrontendFolder = new File(projectRoot, "frontend/");
        File nodeModulesFolder = new File(projectRoot, NODE_MODULES);
        File flowFrontendFolder = new File(nodeModulesFolder, "@vaadin/flow-frontend");
        List<File> candidateParents = path.startsWith(DEFAULT_NODE_DIR) ? Arrays.asList(localFrontendFolder, flowFrontendFolder) : Arrays.asList(nodeModulesFolder, localFrontendFolder, flowFrontendFolder);
        return candidateParents.stream().map(parent -> new File((File)parent, path)).filter(File::exists).findFirst().orElse(null);
    }

    public static String getStatsAssetsByChunkName(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        Optional<DevModeHandler> devModeHandler = DevModeHandlerManager.getDevModeHandler(service);
        if (!config.isProductionMode() && config.enableDevServer() && devModeHandler.isPresent()) {
            return FrontendUtils.streamToString(FrontendUtils.getResourceFromWebpack(devModeHandler.get(), "/assetsByChunkName", "getting assets by chunk name."));
        }
        InputStream resourceAsStream = config.isStatsExternal() ? FrontendUtils.getStatsFromExternalUrl(config.getExternalStatsUrl(), service.getContext()) : FrontendUtils.getStatsFromClassPath(service);
        if (resourceAsStream == null) {
            return null;
        }
        try (Scanner scan = new Scanner(resourceAsStream, StandardCharsets.UTF_8.name());){
            StringBuilder assets = new StringBuilder();
            assets.append("{");
            FrontendUtils.scanToAssetChunkStart(scan, assets);
            while (scan.hasNextLine()) {
                String line = scan.nextLine().trim();
                if ("}".equals(line) || "},".equals(line)) {
                    String string = assets.append("}").toString();
                    return string;
                }
                if (line.endsWith("}") || line.endsWith("},")) {
                    String string = assets.append(line.substring(0, line.indexOf(125)).trim()).append("}").toString();
                    return string;
                }
                if (line.contains("{")) break;
                assets.append(line);
            }
            FrontendUtils.getLogger().error("Could not parse assetsByChunkName from stats.json");
        }
        return null;
    }

    private static void scanToAssetChunkStart(Scanner scan, StringBuilder assets) {
        do {
            String line;
            if (!(line = scan.nextLine().trim()).startsWith("\"assetsByChunkName\"")) continue;
            if (line.endsWith("{")) break;
            assets.append(line.substring(line.indexOf(123) + 1).trim());
            break;
        } while (scan.hasNextLine());
    }

    private static String buildTooOldString(String tool, String version, int supportedMajor, int supportedMinor) {
        return String.format(TOO_OLD, tool, version, supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS);
    }

    public static String getProjectFrontendDir(DeploymentConfiguration configuration) {
        return configuration.getStringProperty(PARAM_FRONTEND_DIR, DEFAULT_FRONTEND_DIR);
    }

    public static boolean isWebpackConfigFile(File file) throws IOException {
        return file.exists() && FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).contains("./webpack.generated.js");
    }

    public static String getUnixRelativePath(Path source, Path target) {
        return FrontendUtils.getUnixPath(source.relativize(target));
    }

    public static String getUnixPath(Path source) {
        return source.toString().replaceAll("\\\\", "/");
    }

    public static FallbackChunk readFallbackChunk(JsonObject object) {
        if (!object.hasKey(CHUNKS)) {
            return null;
        }
        JsonObject obj = object.getObject(CHUNKS);
        if (!obj.hasKey(FALLBACK)) {
            return null;
        }
        obj = obj.getObject(FALLBACK);
        ArrayList<String> fallbackModles = new ArrayList<String>();
        JsonArray modules = obj.getArray(JS_MODULES);
        for (int i = 0; i < modules.length(); ++i) {
            fallbackModles.add(modules.getString(i));
        }
        ArrayList<FallbackChunk.CssImportData> fallbackCss = new ArrayList<FallbackChunk.CssImportData>();
        JsonArray css = obj.getArray(CSS_IMPORTS);
        for (int i = 0; i < css.length(); ++i) {
            fallbackCss.add(FrontendUtils.createCssData(css.getObject(i)));
        }
        return new FallbackChunk(fallbackModles, fallbackCss);
    }

    private static FallbackChunk.CssImportData createCssData(JsonObject object) {
        String value = null;
        String id = null;
        String include = null;
        String themeFor = null;
        if (object.hasKey("value")) {
            value = object.getString("value");
        }
        if (object.hasKey("id")) {
            id = object.getString("id");
        }
        if (object.hasKey("include")) {
            include = object.getString("include");
        }
        if (object.hasKey("themeFor")) {
            themeFor = object.getString("themeFor");
        }
        return new FallbackChunk.CssImportData(value, id, include, themeFor);
    }

    static void validateToolVersion(String tool, FrontendVersion toolVersion, FrontendVersion supported) {
        if (FrontendUtils.isVersionAtLeast(toolVersion, supported)) {
            return;
        }
        throw new IllegalStateException(FrontendUtils.buildTooOldString(tool, toolVersion.getFullVersion(), supported.getMajorVersion(), supported.getMinorVersion()));
    }

    static boolean isVersionAtLeast(FrontendVersion toolVersion, FrontendVersion required) {
        int major = toolVersion.getMajorVersion();
        int minor = toolVersion.getMinorVersion();
        return major > required.getMajorVersion() || major == required.getMajorVersion() && minor >= required.getMinorVersion();
    }

    protected static FrontendVersion getVersion(String tool, List<String> versionCommand) throws UnknownVersionException {
        String output;
        try {
            output = FrontendUtils.executeCommand(versionCommand);
        }
        catch (CommandExecutionException e) {
            throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand), e);
        }
        try {
            return new FrontendVersion(FrontendUtils.parseVersionString(output));
        }
        catch (IOException e) {
            throw new UnknownVersionException(tool, "Expected a version number as output but got '" + output + "' when using command " + String.join((CharSequence)" ", versionCommand), e);
        }
    }

    public static String executeCommand(List<String> command) throws CommandExecutionException {
        try {
            Process process = FrontendUtils.createProcessBuilder(command).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new CommandExecutionException(exitCode);
            }
            return FrontendUtils.streamToString(process.getInputStream());
        }
        catch (IOException | InterruptedException e) {
            throw new CommandExecutionException(e);
        }
    }

    public static FrontendVersion parseFrontendVersion(String versionString) throws IOException {
        return new FrontendVersion(FrontendUtils.parseVersionString(versionString));
    }

    public static File getVaadinHomeDirectory() {
        File home = FileUtils.getUserDirectory();
        if (!home.exists()) {
            throw new IllegalStateException("The user directory '" + home.getAbsolutePath() + "' doesn't exist");
        }
        if (!home.isDirectory()) {
            throw new IllegalStateException("The path '" + home.getAbsolutePath() + "' is not a directory");
        }
        File vaadinFolder = new File(home, ".vaadin");
        if (vaadinFolder.exists()) {
            if (vaadinFolder.isDirectory()) {
                return vaadinFolder;
            }
            throw new IllegalStateException("The path '" + vaadinFolder.getAbsolutePath() + "' is not a directory. This path is used to store vaadin related data. Please either remove the file or create a directory");
        }
        try {
            FileUtils.forceMkdir((File)vaadinFolder);
            return vaadinFolder;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't create '.vaadin' folder inside home directory '" + home.getAbsolutePath() + "'", exception);
        }
    }

    static String parseVersionString(String output) throws IOException {
        Optional<String> lastOuput = Stream.of(output.split("\n")).filter(line -> !line.matches("^[ ]*$")).reduce((first, second) -> second);
        return lastOuput.map(line -> line.replaceFirst("^v", "")).orElseThrow(() -> new IOException("No output"));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FrontendUtils.class);
    }

    public static String commandToString(String baseDir, List<String> command) {
        StringBuilder retval = new StringBuilder("\n");
        StringBuilder curLine = new StringBuilder();
        for (String fragment : command) {
            if (curLine.length() + fragment.length() > 55) {
                retval.append(curLine.toString());
                retval.append("\\ \n");
                curLine = new StringBuilder("    ");
            }
            curLine.append(fragment.replace(baseDir, "."));
            curLine.append(" ");
        }
        retval.append(curLine.toString());
        retval.append("\n");
        return retval.toString();
    }

    public static FrontendVersion getPackageVersionFromJson(JsonObject sourceJson, String pkg, String versionOrigin) {
        if (!sourceJson.hasKey(pkg)) {
            return null;
        }
        try {
            String versionString = sourceJson.getString(pkg);
            return new FrontendVersion(pkg, versionString);
        }
        catch (ClassCastException classCastException) {
            LoggerFactory.getLogger(FrontendVersion.class).warn("Ignoring error while parsing frontend dependency version for package '{}' in '{}'", (Object)pkg, (Object)versionOrigin);
        }
        catch (NumberFormatException nfe) {
            LoggerFactory.getLogger(FrontendVersion.class).warn("Ignoring error while parsing frontend dependency version in {}: {}", (Object)versionOrigin, (Object)nfe.getMessage());
        }
        return null;
    }

    public static void console(String format, Object message) {
        System.out.print(String.format(format, message));
    }

    public static void deleteNodeModules(File nodeModules) throws IOException {
        if (!nodeModules.exists()) {
            return;
        }
        if (!nodeModules.isDirectory() || !nodeModules.getName().equals("node_modules")) {
            throw new IOException(nodeModules.getAbsolutePath() + " does not look like a node_modules directory");
        }
        Path nodeModulesPath = nodeModules.toPath();
        try (Stream<Path> walk = Files.walk(nodeModulesPath, new FileVisitOption[0]);){
            String undeletable = walk.sorted(Comparator.reverseOrder()).map(Path::toFile).filter(file -> !file.delete()).map(File::getAbsolutePath).collect(Collectors.joining(", "));
            if (!undeletable.isEmpty() && nodeModules.exists()) {
                throw new IOException("Unable to delete files: " + undeletable);
            }
        }
    }

    private static class Stats
    implements Serializable {
        private final String lastModified;
        protected final byte[] statsJson;

        public Stats(byte[] statsJson, String lastModified) {
            this.statsJson = statsJson;
            this.lastModified = lastModified;
        }

        public Optional<LocalDateTime> getLastModified() {
            if (this.lastModified == null) {
                return Optional.empty();
            }
            return Optional.of(ZonedDateTime.parse(this.lastModified, DateTimeFormatter.RFC_1123_DATE_TIME).toLocalDateTime());
        }
    }

    public static class CommandExecutionException
    extends Exception {
        public CommandExecutionException(int processExitCode) {
            super("Process execution failed with exit code " + processExitCode);
        }

        public CommandExecutionException(Throwable cause) {
            super("Process execution failed", cause);
        }
    }

    public static class UnknownVersionException
    extends Exception {
        public UnknownVersionException(String tool, String extraInfo) {
            super("Unable to detect version of " + tool + ". " + extraInfo);
        }

        public UnknownVersionException(String tool, String extraInfo, Exception cause) {
            super("Unable to detect version of " + tool + ". " + extraInfo, cause);
        }
    }
}

