/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.di;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.InvalidI18NConfigurationException;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DefaultInstantiator
implements Instantiator {
    private VaadinService service;
    private static final AtomicReference<I18NProvider> i18nProvider = new AtomicReference();

    public DefaultInstantiator(VaadinService service) {
        this.service = service;
    }

    @Override
    public boolean init(VaadinService service) {
        return service == this.service;
    }

    @Override
    public Stream<VaadinServiceInitListener> getServiceInitListeners() {
        return DefaultInstantiator.getServiceLoaderListeners(this.service.getClassLoader());
    }

    @Override
    public <T> T getOrCreate(Class<T> type) {
        return this.create(type);
    }

    @Override
    public <T extends Component> T createComponent(Class<T> componentClass) {
        return (T)((Component)this.create(componentClass));
    }

    public static Stream<VaadinServiceInitListener> getServiceLoaderListeners(ClassLoader classloader) {
        ServiceLoader<VaadinServiceInitListener> loader = ServiceLoader.load(VaadinServiceInitListener.class, classloader);
        return StreamSupport.stream(loader.spliterator(), false);
    }

    @Override
    public I18NProvider getI18NProvider() {
        if (i18nProvider.get() == null) {
            i18nProvider.compareAndSet(null, this.getI18NProviderInstance());
        }
        return i18nProvider.get();
    }

    private I18NProvider getI18NProviderInstance() {
        String property = this.getI18NProviderProperty();
        if (property == null) {
            return null;
        }
        try {
            Class<?> providerClass = DefaultInstantiator.class.getClassLoader().loadClass(property);
            if (I18NProvider.class.isAssignableFrom(providerClass)) {
                return (I18NProvider)ReflectTools.createInstance(providerClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw new InvalidI18NConfigurationException("Failed to load given provider class '" + property + "' as it was not found by the class loader.", e);
        }
        return null;
    }

    private String getI18NProviderProperty() {
        DeploymentConfiguration deploymentConfiguration = this.service.getDeploymentConfiguration();
        if (deploymentConfiguration == null) {
            return null;
        }
        return deploymentConfiguration.getStringProperty("i18n.provider", null);
    }

    private <T> T create(Class<T> type) {
        return ReflectTools.createInstance(type);
    }
}

